"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedAlertsUpsell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _translations = require("./translations");
var _kibana = require("../../../lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpsellContainer = _common.euiStyled.div`
  border: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
  padding: 12px;
  border-radius: 6px;
`;
const StyledIcon = (0, _common.euiStyled)(_eui.EuiIcon)`
  margin-right: 10px;
`;
const RelatedAlertsUpsell = /*#__PURE__*/_react.default.memo(() => {
  const {
    getAppUrl,
    navigateTo
  } = (0, _kibana.useNavigation)();
  const subscriptionUrl = getAppUrl({
    appId: 'management',
    path: 'stack/license_management'
  });
  const goToSubscription = (0, _react.useCallback)(() => {
    navigateTo({
      url: subscriptionUrl
    });
  }, [navigateTo, subscriptionUrl]);
  return /*#__PURE__*/_react.default.createElement(UpsellContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StyledIcon, {
    size: "m",
    type: "lock"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "subdued",
    onClick: goToSubscription,
    target: "_blank"
  }, _translations.INSIGHTS_UPSELL)))));
});
exports.RelatedAlertsUpsell = RelatedAlertsUpsell;
RelatedAlertsUpsell.displayName = 'RelatedAlertsUpsell';