"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FIELDS_WITHOUT_ACTIONS = exports.EVENT_FIELDS_TABLE_CLASS_NAME = void 0;
exports.getEnrichedFieldInfo = getEnrichedFieldInfo;
exports.getIconFromType = exports.getExampleText = void 0;
exports.hasHoverOrRowActions = hasHoverOrRowActions;
exports.tableHasFocus = exports.search = exports.onEventDetailsTabKeyPressed = void 0;
var _fp = require("lodash/fp");
var _public = require("@kbn/timelines-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../timelines/components/timeline/body/renderers/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Defines the behavior of the search input that appears above the table of data
 */
const search = {
  box: {
    incremental: true,
    placeholder: i18n.PLACEHOLDER,
    schema: true
  }
};

/**
 * An item rendered in the table
 */
exports.search = search;
/** Returns example text, or an empty string if the field does not have an example */
const getExampleText = example => !(0, _fp.isEmpty)(example) ? `Example: ${example}` : '';
exports.getExampleText = getExampleText;
const getIconFromType = type => {
  switch (type) {
    case 'string': // fall through
    case 'keyword':
      return 'string';
    case 'number': // fall through
    case 'long':
      return 'number';
    case 'date':
      return 'clock';
    case 'ip':
    case 'geo_point':
      return 'globe';
    case 'object':
      return 'questionInCircle';
    case 'float':
      return 'number';
    default:
      return 'questionInCircle';
  }
};
exports.getIconFromType = getIconFromType;
const EVENT_FIELDS_TABLE_CLASS_NAME = 'event-fields-table';

/**
 * Returns `true` if the Event Details "event fields" table, or it's children,
 * has focus
 */
exports.EVENT_FIELDS_TABLE_CLASS_NAME = EVENT_FIELDS_TABLE_CLASS_NAME;
const tableHasFocus = containerElement => (0, _public.elementOrChildrenHasFocus)(containerElement === null || containerElement === void 0 ? void 0 : containerElement.querySelector(`.${EVENT_FIELDS_TABLE_CLASS_NAME}`));

/**
 * This function has a side effect. It will skip focus "after" or "before"
 * the Event Details table, with exceptions as noted below.
 *
 * If the currently-focused table cell has additional focusable children,
 * i.e. draggables or always-open popover content, the browser's "natural"
 * focus management will determine which element is focused next.
 */
exports.tableHasFocus = tableHasFocus;
const onEventDetailsTabKeyPressed = ({
  containerElement,
  keyboardEvent,
  onSkipFocusBeforeEventsTable,
  onSkipFocusAfterEventsTable
}) => {
  const {
    shiftKey
  } = keyboardEvent;
  const eventFieldsTableSkipFocus = (0, _public.getTableSkipFocus)({
    containerElement,
    getFocusedCell: _public.getFocusedDataColindexCell,
    shiftKey,
    tableHasFocus,
    tableClassName: EVENT_FIELDS_TABLE_CLASS_NAME
  });
  if (eventFieldsTableSkipFocus !== 'SKIP_FOCUS_NOOP') {
    (0, _public.stopPropagationAndPreventDefault)(keyboardEvent);
    (0, _public.handleSkipFocus)({
      onSkipFocusBackwards: onSkipFocusBeforeEventsTable,
      onSkipFocusForward: onSkipFocusAfterEventsTable,
      skipFocus: eventFieldsTableSkipFocus
    });
  }
};
exports.onEventDetailsTabKeyPressed = onEventDetailsTabKeyPressed;
function getEnrichedFieldInfo({
  browserFields,
  contextId,
  eventId,
  field,
  item,
  linkValueField,
  scopeId
}) {
  var _item$category, _item$field, _browserField$format, _browserField$type;
  const fieldInfo = {
    contextId,
    eventId,
    fieldType: 'string',
    linkValue: undefined,
    scopeId
  };
  const linkValue = (0, _fp.getOr)(null, 'originalValue.0', linkValueField);
  const category = (_item$category = item.category) !== null && _item$category !== void 0 ? _item$category : '';
  const fieldName = (_item$field = item.field) !== null && _item$field !== void 0 ? _item$field : '';
  const browserField = (0, _fp.get)([category, 'fields', fieldName], browserFields);
  const overrideField = field === null || field === void 0 ? void 0 : field.overrideField;
  return {
    ...fieldInfo,
    data: {
      field: overrideField !== null && overrideField !== void 0 ? overrideField : fieldName,
      format: (_browserField$format = browserField === null || browserField === void 0 ? void 0 : browserField.format) !== null && _browserField$format !== void 0 ? _browserField$format : '',
      type: (_browserField$type = browserField === null || browserField === void 0 ? void 0 : browserField.type) !== null && _browserField$type !== void 0 ? _browserField$type : '',
      isObjectArray: item.isObjectArray
    },
    values: item.values,
    linkValue: linkValue !== null && linkValue !== void 0 ? linkValue : undefined,
    fieldFromBrowserField: browserField
  };
}

/**
 * A lookup table for fields that should not have actions
 */
const FIELDS_WITHOUT_ACTIONS = {
  [_constants.AGENT_STATUS_FIELD_NAME]: true,
  [_constants.QUARANTINED_PATH_FIELD_NAME]: true
};

/**
 * Checks whether the given field should have hover or row actions.
 * The lookup is fast, so it is not necessary to memoize the result.
 */
exports.FIELDS_WITHOUT_ACTIONS = FIELDS_WITHOUT_ACTIONS;
function hasHoverOrRowActions(field) {
  return !FIELDS_WITHOUT_ACTIONS[field];
}