"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventFieldsBrowser = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _polished = require("polished");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/timelines-plugin/public");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _helpers = require("../../../helpers");
var _add_timeline_button = require("../../../timelines/components/flyout/add_timeline_button");
var _timeline = require("../../../timelines/store/timeline");
var _source = require("../../containers/source");
var _helpers2 = require("../../../timelines/components/timeline/body/column_headers/helpers");
var _defaults = require("../../../timelines/store/timeline/defaults");
var _columns = require("./columns");
var _helpers3 = require("./helpers");
var _use_selector = require("../../hooks/use_selector");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TableWrapper = _styledComponents.default.div`
  display: flex;
  flex: 1;
  overflow: hidden;
  > div {
    display: flex;
    flex-direction: column;
    flex: 1;
    overflow: hidden;
    > .euiFlexGroup:first-of-type {
      flex: 0;
    }
  }
`;

// eslint-disable-next-line @typescript-eslint/no-explicit-any
const StyledEuiInMemoryTable = (0, _styledComponents.default)(_eui.EuiInMemoryTable)`
  flex: 1;
  overflow: auto;
  overflow-x: hidden;
  &::-webkit-scrollbar {
    height: ${({
  theme
}) => theme.eui.euiScrollBar};
    width: ${({
  theme
}) => theme.eui.euiScrollBar};
  }
  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorDarkShade, 0.5)};
    border: ${({
  theme
}) => theme.eui.euiScrollBarCorner} solid transparent;
  }
  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }

  .eventFieldsTable__fieldIcon {
    padding-top: ${({
  theme
}) => parseFloat(theme.eui.euiSizeXS) * 1.5}px;
  }

  .eventFieldsTable__fieldName {
    line-height: ${({
  theme
}) => theme.eui.euiLineHeight};
    padding: ${({
  theme
}) => theme.eui.euiSizeXS};
  }

  // TODO: Use this logic from discover
  /* .eventFieldsTable__multiFieldBadge {
    font: ${({
  theme
}) => theme.eui.euiFont};
  } */

  .inlineActions {
    opacity: 0;
  }

  .eventFieldsTable__tableRow {
    font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
    font-family: ${({
  theme
}) => theme.eui.euiCodeFontFamily};

    .inlineActions-popoverOpen {
      opacity: 1;
    }

    &:hover {
      .inlineActions {
        opacity: 1;
      }
    }
  }

  .eventFieldsTable__actionCell,
  .eventFieldsTable__fieldNameCell {
    align-items: flex-start;
    padding: ${({
  theme
}) => theme.eui.euiSizeXS};
  }

  .eventFieldsTable__fieldValue {
    display: inline-block;
    word-break: break-all;
    word-wrap: break-word;
    white-space: pre-wrap;
    line-height: ${({
  theme
}) => theme.eui.euiLineHeight};
    color: ${({
  theme
}) => theme.eui.euiColorFullShade};
    vertical-align: top;
  }
`;

// Match structure in discover
const COUNT_PER_PAGE_OPTIONS = [25, 50, 100];

// Encapsulating the pagination logic for the table.
const useFieldBrowserPagination = () => {
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0
  });
  const onTableChange = (0, _react.useCallback)(({
    page: {
      index
    }
  }) => {
    setPagination({
      pageIndex: index
    });
  }, []);
  const paginationTableProp = (0, _react.useMemo)(() => ({
    ...pagination,
    pageSizeOptions: COUNT_PER_PAGE_OPTIONS
  }), [pagination]);
  return {
    onTableChange,
    paginationTableProp
  };
};

/**
 * This callback, invoked via `EuiInMemoryTable`'s `rowProps, assigns
 * attributes to every `<tr>`.
 */

/** Renders a table view or JSON view of the `ECS` `data` */
const EventFieldsBrowser = /*#__PURE__*/_react.default.memo(({
  browserFields,
  data,
  eventId,
  isDraggable,
  timelineTabType,
  scopeId,
  isReadOnly
}) => {
  const containerElement = (0, _react.useRef)(null);
  const getScope = (0, _react.useMemo)(() => {
    if ((0, _helpers.isTimelineScope)(scopeId)) {
      return _timeline.timelineSelectors.getTimelineByIdSelector();
    } else if ((0, _helpers.isInTableScope)(scopeId)) {
      return _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();
    }
  }, [scopeId]);
  const defaults = (0, _helpers.isTimelineScope)(scopeId) ? _defaults.timelineDefaults : _securitysolutionDataTable.tableDefaults;
  const columnHeaders = (0, _use_selector.useDeepEqualSelector)(state => {
    var _ref;
    const {
      columns
    } = (_ref = getScope && getScope(state, scopeId)) !== null && _ref !== void 0 ? _ref : defaults;
    return (0, _helpers2.getColumnHeaders)(columns, browserFields);
  });
  const fieldsByName = (0, _react.useMemo)(() => (0, _source.getAllFieldsByName)(browserFields), [browserFields]);
  const items = (0, _react.useMemo)(() => (0, _fp.sortBy)(['field'], data).map((item, i) => ({
    ...item,
    ...fieldsByName[item.field],
    valuesConcatenated: item.values != null ? item.values.join() : '',
    ariaRowindex: (0, _public.arrayIndexToAriaIndex)(i)
  })), [data, fieldsByName]);
  const getLinkValue = (0, _react.useCallback)(field => {
    var _columnHeaders$find;
    const linkField = ((_columnHeaders$find = columnHeaders.find(col => col.id === field)) !== null && _columnHeaders$find !== void 0 ? _columnHeaders$find : {}).linkField;
    if (!linkField) {
      return null;
    }
    const linkFieldData = (data !== null && data !== void 0 ? data : []).find(d => d.field === linkField);
    const linkFieldValue = (0, _fp.getOr)(null, 'originalValue', linkFieldData);
    return Array.isArray(linkFieldValue) ? linkFieldValue[0] : linkFieldValue;
  }, [data, columnHeaders]);
  const onSetRowProps = (0, _react.useCallback)(({
    ariaRowindex,
    field
  }) => {
    const rowIndex = ariaRowindex != null ? {
      'data-rowindex': ariaRowindex
    } : {};
    return {
      ...rowIndex,
      className: 'eventFieldsTable__tableRow',
      'data-test-subj': `event-fields-table-row-${field}`
    };
  }, []);
  const columns = (0, _react.useMemo)(() => (0, _columns.getColumns)({
    browserFields,
    eventId,
    contextId: `event-fields-browser-for-${scopeId}-${timelineTabType}`,
    scopeId,
    getLinkValue,
    isDraggable,
    isReadOnly
  }), [browserFields, eventId, scopeId, timelineTabType, getLinkValue, isDraggable, isReadOnly]);
  const focusSearchInput = (0, _react.useCallback)(() => {
    var _containerElement$cur, _containerElement$cur2;
    // the selector below is used to focus the input because EuiInMemoryTable does not expose a ref to its built-in search input
    (_containerElement$cur = containerElement.current) === null || _containerElement$cur === void 0 ? void 0 : (_containerElement$cur2 = _containerElement$cur.querySelector('input[type="search"]')) === null || _containerElement$cur2 === void 0 ? void 0 : _containerElement$cur2.focus();
  }, []);
  const focusAddTimelineButton = (0, _react.useCallback)(() => {
    var _document$querySelect;
    // the document selector below is required because we may be in a flyout or full screen timeline context
    (_document$querySelect = document.querySelector(`.${_add_timeline_button.ADD_TIMELINE_BUTTON_CLASS_NAME}`)) === null || _document$querySelect === void 0 ? void 0 : _document$querySelect.focus();
  }, []);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers3.onEventDetailsTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable: focusSearchInput,
        onSkipFocusAfterEventsTable: focusAddTimelineButton
      });
    } else {
      (0, _public.onKeyDownFocusHandler)({
        colindexAttribute: _public.DATA_COLINDEX_ATTRIBUTE,
        containerElement: containerElement === null || containerElement === void 0 ? void 0 : containerElement.current,
        event: keyboardEvent,
        maxAriaColindex: 3,
        maxAriaRowindex: data.length,
        onColumnFocused: _fp.noop,
        rowindexAttribute: _public.DATA_ROWINDEX_ATTRIBUTE
      });
    }
  }, [data, focusAddTimelineButton, focusSearchInput]);
  (0, _react.useEffect)(() => {
    focusSearchInput();
  }, [focusSearchInput]);

  // Pagination
  const {
    onTableChange,
    paginationTableProp
  } = useFieldBrowserPagination();
  return /*#__PURE__*/_react.default.createElement(TableWrapper, {
    onKeyDown: onKeyDown,
    ref: containerElement
  }, /*#__PURE__*/_react.default.createElement(StyledEuiInMemoryTable, {
    className: _helpers3.EVENT_FIELDS_TABLE_CLASS_NAME,
    items: items,
    itemId: "field",
    columns: columns,
    onTableChange: onTableChange,
    pagination: paginationTableProp,
    rowProps: onSetRowProps,
    search: _helpers3.search,
    sorting: false,
    "data-test-subj": "event-fields-browser"
  }));
});
exports.EventFieldsBrowser = EventFieldsBrowser;
EventFieldsBrowser.displayName = 'EventFieldsBrowser';