"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEndpointResponseActionsTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _actions_log_table = require("../../../management/components/endpoint_response_actions_list/components/actions_log_table");
var _hooks = require("../../../management/hooks");
var _event_details = require("./event_details");
var i18n = _interopRequireWildcard(require("./translations"));
var _expand_dotted = require("../../../../common/utils/expand_dotted");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _response_actions = require("../../../../common/detection_engine/rule_response_actions/schemas/response_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabContentWrapper = _styledComponents.default.div`
  height: 100%;
  position: relative;
`;
const useEndpointResponseActionsTab = ({
  rawEventData
}) => {
  var _rawEventData$_id;
  const responseActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointResponseActionsEnabled');
  const {
    data: actionList,
    isFetching,
    isFetched
  } = (0, _hooks.useGetEndpointActionList)({
    alertId: [(_rawEventData$_id = rawEventData === null || rawEventData === void 0 ? void 0 : rawEventData._id) !== null && _rawEventData$_id !== void 0 ? _rawEventData$_id : ''],
    withAutomatedActions: true
  }, {
    retry: false,
    enabled: rawEventData && responseActionsEnabled
  });
  const totalItemCount = (0, _react.useMemo)(() => {
    var _actionList$total;
    return (_actionList$total = actionList === null || actionList === void 0 ? void 0 : actionList.total) !== null && _actionList$total !== void 0 ? _actionList$total : 0;
  }, [actionList]);
  const expandedEventFieldsObject = rawEventData ? (0, _expand_dotted.expandDottedObject)(rawEventData.fields) : undefined;
  const responseActions = (0, _react.useMemo)(() => {
    var _expandedEventFieldsO, _expandedEventFieldsO2, _expandedEventFieldsO3, _expandedEventFieldsO4;
    return expandedEventFieldsObject === null || expandedEventFieldsObject === void 0 ? void 0 : (_expandedEventFieldsO = expandedEventFieldsObject.kibana) === null || _expandedEventFieldsO === void 0 ? void 0 : (_expandedEventFieldsO2 = _expandedEventFieldsO.alert) === null || _expandedEventFieldsO2 === void 0 ? void 0 : (_expandedEventFieldsO3 = _expandedEventFieldsO2.rule) === null || _expandedEventFieldsO3 === void 0 ? void 0 : (_expandedEventFieldsO4 = _expandedEventFieldsO3.parameters) === null || _expandedEventFieldsO4 === void 0 ? void 0 : _expandedEventFieldsO4[0].response_actions;
  }, [expandedEventFieldsObject]);
  const endpointResponseActions = (0, _react.useMemo)(() => responseActions === null || responseActions === void 0 ? void 0 : responseActions.filter(responseAction => responseAction.action_type_id === _response_actions.RESPONSE_ACTION_TYPES.ENDPOINT), [responseActions]);
  if (!(endpointResponseActions !== null && endpointResponseActions !== void 0 && endpointResponseActions.length) || !rawEventData || !responseActionsEnabled) {
    return;
  }
  return {
    id: _event_details.EventsViewType.endpointView,
    'data-test-subj': 'endpointViewTab',
    name: i18n.ENDPOINT_VIEW,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      "data-test-subj": "endpoint-actions-notification"
    }, totalItemCount),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(TabContentWrapper, {
      "data-test-subj": "endpointViewWrapper"
    }, isFetched && totalItemCount ? /*#__PURE__*/_react.default.createElement(_actions_log_table.ActionsLogTable, {
      "data-test-subj": "endpoint-actions-results-table",
      isFlyout: false,
      onShowActionDetails: () => null,
      items: (actionList === null || actionList === void 0 ? void 0 : actionList.data) || [],
      loading: isFetching,
      onChange: () => null,
      totalItemCount: totalItemCount,
      queryParams: {
        withAutomatedActions: true
      },
      showHostNames: true
    }) : null))
  };
};
exports.useEndpointResponseActionsTab = useEndpointResponseActionsTab;