"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  FEED_NAME_PREPOSITION: true,
  INDICATOR_ENRICHMENT_TITLE: true,
  INVESTIGATION_ENRICHMENT_TITLE: true,
  INDICATOR_TOOLTIP_CONTENT: true,
  INFORMATION_ARIA_LABEL: true,
  INVESTIGATION_TOOLTIP_CONTENT: true,
  NO_INVESTIGATION_ENRICHMENTS_DESCRIPTION: true,
  NO_ENRICHMENTS_FOUND_DESCRIPTION: true,
  INVESTIGATION_QUERY_TITLE: true,
  ENRICHMENT_LOOKBACK_START_DATE: true,
  ENRICHMENT_LOOKBACK_END_DATE: true,
  REFRESH: true,
  ENRICHED_DATA: true,
  CURRENT_RISK_CLASSIFICATION: true,
  ORIGINAL_RISK_CLASSIFICATION: true,
  RISK_DATA_TITLE: true
};
exports.RISK_DATA_TITLE = exports.REFRESH = exports.ORIGINAL_RISK_CLASSIFICATION = exports.NO_INVESTIGATION_ENRICHMENTS_DESCRIPTION = exports.NO_ENRICHMENTS_FOUND_DESCRIPTION = exports.INVESTIGATION_TOOLTIP_CONTENT = exports.INVESTIGATION_QUERY_TITLE = exports.INVESTIGATION_ENRICHMENT_TITLE = exports.INFORMATION_ARIA_LABEL = exports.INDICATOR_TOOLTIP_CONTENT = exports.INDICATOR_ENRICHMENT_TITLE = exports.FEED_NAME_PREPOSITION = exports.ENRICHMENT_LOOKBACK_START_DATE = exports.ENRICHMENT_LOOKBACK_END_DATE = exports.ENRICHED_DATA = exports.CURRENT_RISK_CLASSIFICATION = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../../../explore/components/risk_score/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FEED_NAME_PREPOSITION = _i18n.i18n.translate('xpack.securitySolution.eventDetails.ctiSummary.feedNamePreposition', {
  defaultMessage: 'from'
});
exports.FEED_NAME_PREPOSITION = FEED_NAME_PREPOSITION;
const INDICATOR_ENRICHMENT_TITLE = _i18n.i18n.translate('xpack.securitySolution.eventDetails.ctiSummary.indicatorEnrichmentTitle', {
  defaultMessage: 'Threat Match Detected'
});
exports.INDICATOR_ENRICHMENT_TITLE = INDICATOR_ENRICHMENT_TITLE;
const INVESTIGATION_ENRICHMENT_TITLE = _i18n.i18n.translate('xpack.securitySolution.eventDetails.ctiSummary.investigationEnrichmentTitle', {
  defaultMessage: 'Enriched with Threat Intelligence'
});
exports.INVESTIGATION_ENRICHMENT_TITLE = INVESTIGATION_ENRICHMENT_TITLE;
const INDICATOR_TOOLTIP_CONTENT = _i18n.i18n.translate('xpack.securitySolution.eventDetails.ctiSummary.indicatorEnrichmentTooltipContent', {
  defaultMessage: 'This field value matched a threat intelligence indicator with a rule you created.'
});
exports.INDICATOR_TOOLTIP_CONTENT = INDICATOR_TOOLTIP_CONTENT;
const INFORMATION_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.eventDetails.ctiSummary.informationAriaLabel', {
  defaultMessage: 'Information'
});
exports.INFORMATION_ARIA_LABEL = INFORMATION_ARIA_LABEL;
const INVESTIGATION_TOOLTIP_CONTENT = _i18n.i18n.translate('xpack.securitySolution.eventDetails.ctiSummary.investigationEnrichmentTooltipContent', {
  defaultMessage: 'This field value has additional information available from threat intelligence sources.'
});
exports.INVESTIGATION_TOOLTIP_CONTENT = INVESTIGATION_TOOLTIP_CONTENT;
const NO_INVESTIGATION_ENRICHMENTS_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.alertDetails.noInvestigationEnrichmentsDescription', {
  defaultMessage: "We haven't found field value has additional information available from threat intelligence sources we searched in the past 30 days by default."
});
exports.NO_INVESTIGATION_ENRICHMENTS_DESCRIPTION = NO_INVESTIGATION_ENRICHMENTS_DESCRIPTION;
const NO_ENRICHMENTS_FOUND_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.alertDetails.noEnrichmentsFoundDescription', {
  defaultMessage: 'We did not find threat intelligence that matches any of the indicator match rules, or any enrichment for this alert.'
});
exports.NO_ENRICHMENTS_FOUND_DESCRIPTION = NO_ENRICHMENTS_FOUND_DESCRIPTION;
const INVESTIGATION_QUERY_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertDetails.investigationTimeQueryTitle', {
  defaultMessage: 'Enrichment with Threat Intelligence'
});
exports.INVESTIGATION_QUERY_TITLE = INVESTIGATION_QUERY_TITLE;
const ENRICHMENT_LOOKBACK_START_DATE = _i18n.i18n.translate('xpack.securitySolution.alertDetails.enrichmentQueryStartDate', {
  defaultMessage: 'Start date'
});
exports.ENRICHMENT_LOOKBACK_START_DATE = ENRICHMENT_LOOKBACK_START_DATE;
const ENRICHMENT_LOOKBACK_END_DATE = _i18n.i18n.translate('xpack.securitySolution.alertDetails.enrichmentQueryEndDate', {
  defaultMessage: 'End date'
});
exports.ENRICHMENT_LOOKBACK_END_DATE = ENRICHMENT_LOOKBACK_END_DATE;
const REFRESH = _i18n.i18n.translate('xpack.securitySolution.alertDetails.refresh', {
  defaultMessage: 'Refresh'
});
exports.REFRESH = REFRESH;
const ENRICHED_DATA = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.enrichedDataTitle', {
  defaultMessage: 'Enriched data'
});
exports.ENRICHED_DATA = ENRICHED_DATA;
const CURRENT_RISK_CLASSIFICATION = riskEntity => _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.hostRiskClassification', {
  defaultMessage: 'Current {riskEntity} risk classification',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity, true)
  }
});
exports.CURRENT_RISK_CLASSIFICATION = CURRENT_RISK_CLASSIFICATION;
const ORIGINAL_RISK_CLASSIFICATION = riskEntity => _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.originalHostRiskClassification', {
  defaultMessage: 'Original {riskEntity} risk classification',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity, true)
  }
});
exports.ORIGINAL_RISK_CLASSIFICATION = ORIGINAL_RISK_CLASSIFICATION;
const RISK_DATA_TITLE = riskEntity => _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.hostRiskDataTitle', {
  defaultMessage: '{riskEntity} Risk Data',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity)
  }
});
exports.RISK_DATA_TITLE = RISK_DATA_TITLE;