"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatSummaryView = exports.ThreatSummaryPanelHeader = exports.EnrichedDataRow = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _risk_summary = require("./risk_summary");
var _enrichment_summary = require("./enrichment_summary");
var _search_strategy = require("../../../../../common/search_strategy");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UppercaseEuiTitle = (0, _styledComponents.default)(_eui.EuiTitle)`
  text-transform: uppercase;
`;
const ThreatSummaryPanelTitle = ({
  children
}) => /*#__PURE__*/_react.default.createElement(UppercaseEuiTitle, {
  size: "xxxs"
}, /*#__PURE__*/_react.default.createElement("h5", null, children));
const StyledEnrichmentFieldTitle = (0, _styledComponents.default)(_eui.EuiTitle)`
  width: 220px;
`;
const EnrichmentFieldTitle = ({
  title
}) => /*#__PURE__*/_react.default.createElement(StyledEnrichmentFieldTitle, {
  size: "xxxs"
}, /*#__PURE__*/_react.default.createElement("h6", null, title));
const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  margin-top: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const EnrichedDataRow = ({
  field,
  value
}) => /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
  direction: "row",
  gutterSize: "none",
  responsive: true,
  alignItems: "center",
  "data-test-subj": "EnrichedDataRow"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  style: {
    flexShrink: 0
  },
  grow: false
}, /*#__PURE__*/_react.default.createElement(EnrichmentFieldTitle, {
  title: field
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  className: "eui-textBreakWord"
}, value));
exports.EnrichedDataRow = EnrichedDataRow;
const ThreatSummaryPanelHeader = ({
  title,
  toolTipContent,
  toolTipTitle
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen, setIsPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ThreatSummaryPanelTitle, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "leftCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "text",
      size: "xs",
      iconSize: "m",
      iconType: "iInCircle",
      "aria-label": i18n.INFORMATION_ARIA_LABEL,
      onClick: onClick
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, toolTipTitle !== null && toolTipTitle !== void 0 ? toolTipTitle : title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    style: {
      width: '270px'
    }
  }, toolTipContent))));
};
exports.ThreatSummaryPanelHeader = ThreatSummaryPanelHeader;
const ThreatSummaryViewComponent = ({
  browserFields,
  data,
  enrichments,
  eventId,
  scopeId,
  hostRisk,
  userRisk,
  isDraggable,
  isReadOnly
}) => {
  var _data$find, _data$find$values, _data$find2, _data$find2$values;
  const originalHostRisk = data === null || data === void 0 ? void 0 : (_data$find = data.find(eventDetail => (eventDetail === null || eventDetail === void 0 ? void 0 : eventDetail.field) === 'host.risk.calculated_level')) === null || _data$find === void 0 ? void 0 : (_data$find$values = _data$find.values) === null || _data$find$values === void 0 ? void 0 : _data$find$values[0];
  const originalUserRisk = data === null || data === void 0 ? void 0 : (_data$find2 = data.find(eventDetail => (eventDetail === null || eventDetail === void 0 ? void 0 : eventDetail.field) === 'user.risk.calculated_level')) === null || _data$find2 === void 0 ? void 0 : (_data$find2$values = _data$find2.values) === null || _data$find2$values === void 0 ? void 0 : _data$find2$values[0];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.ENRICHED_DATA)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    style: {
      flexGrow: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_risk_summary.RiskSummary, {
    riskEntity: _search_strategy.RiskScoreEntity.host,
    risk: hostRisk,
    originalRisk: originalHostRisk
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_risk_summary.RiskSummary, {
    riskEntity: _search_strategy.RiskScoreEntity.user,
    risk: userRisk,
    originalRisk: originalUserRisk
  })), /*#__PURE__*/_react.default.createElement(_enrichment_summary.EnrichmentSummary, {
    browserFields: browserFields,
    data: data,
    enrichments: enrichments,
    scopeId: scopeId,
    eventId: eventId,
    isDraggable: isDraggable,
    isReadOnly: isReadOnly
  })));
};
const ThreatSummaryView = /*#__PURE__*/_react.default.memo(ThreatSummaryViewComponent);
exports.ThreatSummaryView = ThreatSummaryView;