"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var i18n = _interopRequireWildcard(require("./translations"));
var _threat_summary_view = require("./threat_summary_view");
var _common = require("../../../../explore/components/risk_score/severity/common");
var _search_strategy = require("../../../../../common/search_strategy");
var _empty_value = require("../../empty_value");
var _risk_score_doc_link = require("../../../../explore/components/risk_score/risk_score_onboarding/risk_score_doc_link");
var _risk_score_header_title = require("../../../../explore/components/risk_score/risk_score_onboarding/risk_score_header_title");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskSummaryComponent = ({
  risk,
  riskEntity,
  originalRisk
}) => {
  var _risk$result, _risk$result$, _risk$result$$host, _risk$result$$host$ri, _risk$result2, _risk$result2$, _risk$result2$$user, _risk$result2$$user$r;
  const currentRiskScore = riskEntity === _search_strategy.RiskScoreEntity.host ? risk === null || risk === void 0 ? void 0 : (_risk$result = risk.result) === null || _risk$result === void 0 ? void 0 : (_risk$result$ = _risk$result[0]) === null || _risk$result$ === void 0 ? void 0 : (_risk$result$$host = _risk$result$.host) === null || _risk$result$$host === void 0 ? void 0 : (_risk$result$$host$ri = _risk$result$$host.risk) === null || _risk$result$$host$ri === void 0 ? void 0 : _risk$result$$host$ri.calculated_level : risk === null || risk === void 0 ? void 0 : (_risk$result2 = risk.result) === null || _risk$result2 === void 0 ? void 0 : (_risk$result2$ = _risk$result2[0]) === null || _risk$result2$ === void 0 ? void 0 : (_risk$result2$$user = _risk$result2$.user) === null || _risk$result2$$user === void 0 ? void 0 : (_risk$result2$$user$r = _risk$result2$$user.risk) === null || _risk$result2$$user$r === void 0 ? void 0 : _risk$result2$$user$r.calculated_level;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "s",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_threat_summary_view.ThreatSummaryPanelHeader, {
    title: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
      title: i18n.RISK_DATA_TITLE(riskEntity),
      riskScoreEntity: riskEntity
    }),
    toolTipTitle: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
      title: i18n.RISK_DATA_TITLE(riskEntity),
      riskScoreEntity: riskEntity,
      showTechnicalPreviewBadge: true
    }),
    toolTipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.alertDetails.overview.riskDataTooltipContent",
      defaultMessage: "Risk classification is displayed only when available for a {riskEntity}. Ensure {riskScoreDocumentationLink} is enabled within your environment.",
      values: {
        riskEntity,
        riskScoreDocumentationLink: /*#__PURE__*/_react.default.createElement(_risk_score_doc_link.RiskScoreDocLink, {
          riskScoreEntity: riskEntity,
          title: i18n.RISK_SCORE_TITLE(riskEntity)
        })
      }
    })
  }), risk.loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "loading"
  }), !risk.loading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_threat_summary_view.EnrichedDataRow, {
    field: i18n.CURRENT_RISK_CLASSIFICATION(riskEntity),
    value: currentRiskScore ? /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
      severity: currentRiskScore,
      hideBackgroundColor: true
    }) : (0, _empty_value.getEmptyValue)()
  }), originalRisk && currentRiskScore !== originalRisk && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_threat_summary_view.EnrichedDataRow, {
    field: i18n.ORIGINAL_RISK_CLASSIFICATION(riskEntity),
    value: /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
      severity: originalRisk,
      hideBackgroundColor: true
    })
  })))));
};
const RiskSummary = /*#__PURE__*/_react.default.memo(RiskSummaryComponent);
exports.RiskSummary = RiskSummary;