"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkToApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_navigate_to_app_event_handler = require("../../hooks/endpoint/use_navigate_to_app_event_handler");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * An `EuiLink` that will use Kibana's `.application.navigateToApp()` to redirect the user to the
 * a given app without causing a full browser refresh
 */
const LinkToApp = /*#__PURE__*/(0, _react.memo)(({
  appId = _constants.APP_UI_ID,
  deepLinkId,
  appPath: path,
  appState: state,
  onClick,
  asButton,
  children,
  ...otherProps
}) => {
  const handleOnClick = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)(appId, {
    deepLinkId,
    path,
    state,
    onClick
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, asButton && asButton === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, otherProps, {
    onClick: handleOnClick
  }), children) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, otherProps, {
    onClick: handleOnClick
  }), children));
});
exports.LinkToApp = LinkToApp;