"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DraggableFieldBadge = void 0;
var _polished = require("polished");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Field = _styledComponents.default.div.attrs(({
  width
}) => {
  if (width) {
    return {
      style: {
        width: `${width}px`
      }
    };
  }
})`
  background-color: ${({
  theme
}) => theme.eui.euiColorEmptyShade};
  border: ${({
  theme
}) => theme.eui.euiBorderThin};
  box-shadow: 0 2px 2px -1px ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorMediumShade, 0.3)},
    0 1px 5px -2px ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorMediumShade, 0.3)};
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  font-weight: ${({
  theme
}) => theme.eui.euiFontWeightSemiBold};
  line-height: ${({
  theme
}) => theme.eui.euiLineHeight};
  padding: ${({
  theme
}) => theme.eui.euiSizeXS};
`;
Field.displayName = 'Field';

/**
 * Renders a field (e.g. `event.action`) as a draggable badge
 */

const DraggableFieldBadge = /*#__PURE__*/_react.default.memo(({
  fieldId,
  fieldWidth
}) => /*#__PURE__*/_react.default.createElement(Field, {
  "data-test-subj": "field",
  width: fieldWidth
}, fieldId));
exports.DraggableFieldBadge = DraggableFieldBadge;
DraggableFieldBadge.displayName = 'DraggableFieldBadge';