"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DragDropContextWrapperComponent = exports.DragDropContextWrapper = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactBeautifulDnd = require("react-beautiful-dnd");
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _store = require("../../store");
var _timeline = require("../../../timelines/store/timeline");
var _helpers = require("../../../timelines/components/timeline/data_providers/helpers");
var _translations = require("../../hooks/translations");
var _toasters = require("../toasters");
var _timeline2 = require("../../../../common/types/timeline");
var _helpers2 = require("./helpers");
var _use_selector = require("../../hooks/use_selector");
var _kibana = require("../../lib/kibana");
var _defaults = require("../../../timelines/store/timeline/defaults");
var _default_alert_headers = require("../events_viewer/default_alert_headers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error
window['__react-beautiful-dnd-disable-dev-warnings'] = true;
const onDragEndHandler = ({
  activeTimelineDataProviders,
  browserFields,
  dataProviders,
  dispatch,
  onAddedToTimeline,
  result
}) => {
  if ((0, _helpers2.userIsReArrangingProviders)(result)) {
    (0, _helpers.reArrangeProviders)({
      dataProviders: activeTimelineDataProviders,
      destination: result.destination,
      dispatch,
      source: result.source,
      timelineId: _timeline2.TimelineId.active
    });
  } else if ((0, _helpers2.providerWasDroppedOnTimeline)(result)) {
    (0, _helpers2.addProviderToTimeline)({
      activeTimelineDataProviders,
      dataProviders,
      dispatch,
      onAddedToTimeline,
      result,
      timelineId: _timeline2.TimelineId.active
    });
  } else if ((0, _helpers2.fieldWasDroppedOnTimelineColumns)(result)) {
    var _result$destination$d, _result$destination;
    (0, _helpers2.addFieldToColumns)({
      browserFields,
      defaultsHeader: _default_alert_headers.defaultAlertsHeaders,
      dispatch,
      result,
      scopeId: (0, _helpers2.getIdFromColumnDroppableId)((_result$destination$d = (_result$destination = result.destination) === null || _result$destination === void 0 ? void 0 : _result$destination.droppableId) !== null && _result$destination$d !== void 0 ? _result$destination$d : '')
    });
  }
};

/**
 * DragDropContextWrapperComponent handles all drag end events
 */
const DragDropContextWrapperComponent = ({
  browserFields,
  children
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getTimeline = (0, _react.useMemo)(() => _timeline.timelineSelectors.getTimelineByIdSelector(), []);
  const getDataProviders = (0, _react.useMemo)(() => _store.dragAndDropSelectors.getDataProvidersSelector(), []);
  const {
    timelines
  } = (0, _kibana.useKibana)().services;
  const sensors = [timelines.getUseAddToTimelineSensor()];
  const {
    dataProviders: activeTimelineDataProviders,
    timelineType
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return (0, _fp.pick)(['dataProviders', 'timelineType'], (_getTimeline = getTimeline(state, _timeline2.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults);
  });
  const dataProviders = (0, _use_selector.useDeepEqualSelector)(getDataProviders);
  const [, dispatchToaster] = (0, _toasters.useStateToaster)();
  const onAddedToTimeline = (0, _react.useCallback)(fieldOrValue => {
    const message = timelineType === _timeline2.TimelineType.template ? (0, _translations.ADDED_TO_TIMELINE_TEMPLATE_MESSAGE)(fieldOrValue) : (0, _translations.ADDED_TO_TIMELINE_MESSAGE)(fieldOrValue);
    (0, _toasters.displaySuccessToast)(message, dispatchToaster);
  }, [dispatchToaster, timelineType]);
  const onDragEnd = (0, _react.useCallback)(result => {
    try {
      enableScrolling();
      if (dataProviders != null) {
        onDragEndHandler({
          activeTimelineDataProviders,
          browserFields,
          dataProviders,
          dispatch,
          onAddedToTimeline,
          result
        });
      }
    } finally {
      document.body.classList.remove(_securitysolutionTGrid.IS_DRAGGING_CLASS_NAME);
      if ((0, _helpers2.draggableIsField)(result)) {
        document.body.classList.remove(_helpers2.IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME);
      }
    }
  }, [activeTimelineDataProviders, browserFields, dataProviders, dispatch, onAddedToTimeline]);
  return /*#__PURE__*/_react.default.createElement(_reactBeautifulDnd.DragDropContext, {
    onDragEnd: onDragEnd,
    onBeforeCapture: onBeforeCapture,
    sensors: sensors
  }, children);
};
exports.DragDropContextWrapperComponent = DragDropContextWrapperComponent;
DragDropContextWrapperComponent.displayName = 'DragDropContextWrapperComponent';
const DragDropContextWrapper = /*#__PURE__*/_react.default.memo(DragDropContextWrapperComponent,
// prevent re-renders when data providers are added or removed, but all other props are the same
(prevProps, nextProps) => (0, _fastDeepEqual.default)(prevProps.children, nextProps.children));
exports.DragDropContextWrapper = DragDropContextWrapper;
DragDropContextWrapper.displayName = 'DragDropContextWrapper';
const onBeforeCapture = before => {
  if (!(0, _helpers2.draggableIsField)(before)) {
    document.body.classList.add(_securitysolutionTGrid.IS_DRAGGING_CLASS_NAME);
  }
  if ((0, _helpers2.draggableIsField)(before)) {
    document.body.classList.add(_helpers2.IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME);
  }
};
const enableScrolling = () => window.onscroll = () => _fp.noop;