"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/dashboard-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _reactRedux = require("react-redux");
var _constants = require("../../store/inputs/constants");
var _inputs = require("../../store/inputs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DashboardRendererComponent = ({
  canReadDashboard,
  filters,
  id,
  inputId = _constants.InputsModelId.global,
  onDashboardContainerLoaded,
  query,
  savedObjectId,
  timeRange
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [dashboardContainer, setDashboardContainer] = (0, _react.useState)();
  const getCreationOptions = (0, _react.useCallback)(() => Promise.resolve({
    getInitialInput: () => ({
      timeRange,
      viewMode: _public2.ViewMode.VIEW,
      query,
      filters
    })
  }), [filters, query, timeRange]);
  const refetchByForceRefresh = (0, _react.useCallback)(() => {
    dashboardContainer === null || dashboardContainer === void 0 ? void 0 : dashboardContainer.forceRefresh();
  }, [dashboardContainer]);
  (0, _react.useEffect)(() => {
    dispatch(_inputs.inputsActions.setQuery({
      inputId,
      id,
      refetch: refetchByForceRefresh,
      loading: false,
      inspect: null
    }));
    return () => {
      dispatch(_inputs.inputsActions.deleteOneQuery({
        inputId,
        id
      }));
    };
  }, [dispatch, id, inputId, refetchByForceRefresh]);
  (0, _react.useEffect)(() => {
    dashboardContainer === null || dashboardContainer === void 0 ? void 0 : dashboardContainer.updateInput({
      timeRange,
      query,
      filters
    });
  }, [dashboardContainer, filters, query, timeRange]);
  const handleDashboardLoaded = (0, _react.useCallback)(container => {
    setDashboardContainer(container);
    onDashboardContainerLoaded === null || onDashboardContainerLoaded === void 0 ? void 0 : onDashboardContainerLoaded(container);
  }, [onDashboardContainerLoaded]);
  return savedObjectId && canReadDashboard ? /*#__PURE__*/_react.default.createElement(_public.DashboardRenderer, {
    ref: handleDashboardLoaded,
    savedObjectId: savedObjectId,
    getCreationOptions: getCreationOptions
  }) : null;
};
DashboardRendererComponent.displayName = 'DashboardRendererComponent';
const DashboardRenderer = /*#__PURE__*/_react.default.memo(DashboardRendererComponent);
exports.DashboardRenderer = DashboardRenderer;