"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emptyDonutColor = exports.DonutChartEmpty = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyDonutColor = '#FAFBFD';
exports.emptyDonutColor = emptyDonutColor;
const BigRing = _styledComponents.default.div`
  border-radius: 50%;
  ${({
  size
}) => `height: ${size}px;
    width: ${size}px;
    background-color: ${emptyDonutColor};
    text-align: center;
    line-height: ${size}px;`}
`;
const SmallRing = _styledComponents.default.div`
  border-radius: 50%;
  ${({
  size
}) => `
    height: ${size}px;
    width: ${size}px;
    background-color: ${(0, _eui.useEuiBackgroundColor)('plain')};
    display: inline-block;
    vertical-align: middle;`}
`;
const EmptyDonutChartComponent = ({
  size = 90,
  donutWidth = 20
}) => size - donutWidth > 0 ? /*#__PURE__*/_react.default.createElement(BigRing, {
  size: size,
  "data-test-subj": "empty-donut"
}, /*#__PURE__*/_react.default.createElement(SmallRing, {
  size: size - donutWidth,
  "data-test-subj": "empty-donut-small"
})) : null;
const DonutChartEmpty = /*#__PURE__*/_react.default.memo(EmptyDonutChartComponent);
exports.DonutChartEmpty = DonutChartEmpty;