"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BarChartComponent = exports.BarChartBaseComponent = exports.BarChartBase = exports.BarChart = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _fp = require("lodash/fp");
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _uuid = require("uuid");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _helpers = require("../drag_and_drop/helpers");
var _kibana = require("../../lib/kibana");
var _utils = require("../matrix_histogram/utils");
var _utils2 = require("../utils");
var _validators = require("../../utils/validators");
var _translation = require("./translation");
var _chart_place_holder = require("./chart_place_holder");
var _common = require("./common");
var _draggable_legend = require("./draggable_legend");
var _actions = require("../visualization_actions/actions");
var _hover_visibility_container = require("../hover_visibility_container");
var _utils3 = require("../visualization_actions/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LegendFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overview: hidden;
`;
const checkIfAllTheDataInTheSeriesAreValid = series => series != null && !!(0, _fp.get)('value.length', series) && (series.value || []).every(({
  x,
  y
}) => (0, _fp.isNumber)(y) && y >= 0);
const checkIfAnyValidSeriesExist = data => Array.isArray(data) && !(0, _common.checkIfAllValuesAreZero)(data) && data.some(checkIfAllTheDataInTheSeriesAreValid);
const yAccessors = ['y'];
const splitSeriesAccessors = [datum => (0, _validators.hasValueToDisplay)(datum.g) ? datum.g : _translation.EMPTY_VALUE_LABEL];

// Bar chart rotation: https://ela.st/chart-rotations
const BarChartBaseComponent = ({
  data,
  forceHiddenLegend = false,
  yAxisTitle,
  ...chartConfigs
}) => {
  const theme = (0, _common.useTheme)();
  const timeZone = (0, _kibana.useTimeZone)();
  const xTickFormatter = (0, _fp.get)('configs.axis.xTickFormatter', chartConfigs);
  const yTickFormatter = (0, _fp.get)('configs.axis.yTickFormatter', chartConfigs);
  const tickSize = (0, _fp.getOr)(0, 'configs.axis.tickSize', chartConfigs);
  const xAxisId = `stat-items-barchart-${data[0].key}-x`;
  const yAxisId = `stat-items-barchart-${data[0].key}-y`;
  const settings = {
    ..._common.chartDefaultSettings,
    ...(0, _deepmerge.default)((0, _fp.get)('configs.settings', chartConfigs), {
      theme
    })
  };
  const xAxisStyle = (0, _react.useMemo)(() => (0, _deepmerge.default)({
    tickLine: {
      size: tickSize
    }
  }, (0, _fp.getOr)({}, 'configs.axis.bottom.style', chartConfigs)), [chartConfigs, tickSize]);
  const yAxisStyle = (0, _react.useMemo)(() => (0, _deepmerge.default)({
    tickLine: {
      size: tickSize
    }
  }, (0, _fp.getOr)({}, 'configs.axis.left.style', chartConfigs)), [chartConfigs, tickSize]);
  const xAxisLabelFormat = (0, _fp.get)('configs.axis.bottom.labelFormat', chartConfigs);
  return chartConfigs.width && chartConfigs.height ? /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({}, settings, {
    showLegend: settings.showLegend && !forceHiddenLegend
  })), data.map(series => {
    var _series$value;
    const barSeriesKey = series.key;
    return checkIfAllTheDataInTheSeriesAreValid(series) ? /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
      id: barSeriesKey,
      key: barSeriesKey,
      name: series.key,
      xScaleType: (0, _fp.getOr)(_charts.ScaleType.Linear, 'configs.series.xScaleType', chartConfigs),
      yScaleType: (0, _fp.getOr)(_charts.ScaleType.Linear, 'configs.series.yScaleType', chartConfigs),
      xAccessor: "x",
      yAccessors: yAccessors,
      timeZone: timeZone,
      splitSeriesAccessors: splitSeriesAccessors,
      data: (_series$value = series.value) !== null && _series$value !== void 0 ? _series$value : [],
      stackAccessors: (0, _fp.get)('configs.series.stackAccessors', chartConfigs),
      color: series.color ? series.color : undefined,
      barSeriesStyle: (0, _fp.get)('configs.series.barSeriesStyle', chartConfigs)
    }) : null;
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: xAxisId,
    position: _charts.Position.Bottom,
    showOverlappingTicks: false,
    style: xAxisStyle,
    tickFormat: xTickFormatter,
    labelFormat: xAxisLabelFormat
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: yAxisId,
    position: _charts.Position.Left,
    style: yAxisStyle,
    tickFormat: yTickFormatter,
    title: yAxisTitle
  })) : null;
};
exports.BarChartBaseComponent = BarChartBaseComponent;
BarChartBaseComponent.displayName = 'BarChartBaseComponent';
const BarChartBase = /*#__PURE__*/_react.default.memo(BarChartBaseComponent);
exports.BarChartBase = BarChartBase;
BarChartBase.displayName = 'BarChartBase';
const NO_LEGEND_DATA = [];
const BarChartComponent = ({
  barChart,
  configs,
  stackByField,
  scopeId,
  visualizationActionsOptions
}) => {
  const {
    ref: measureRef,
    width,
    height
  } = (0, _utils2.useThrottledResizeObserver)();
  const legendItems = (0, _react.useMemo)(() => barChart != null && stackByField != null ? barChart.map((d, i) => {
    var _d$color;
    return {
      color: (_d$color = d.color) !== null && _d$color !== void 0 ? _d$color : i < _utils.defaultLegendColors.length ? _utils.defaultLegendColors[i] : undefined,
      dataProviderId: (0, _helpers.escapeDataProviderId)(`draggable-legend-item-${(0, _uuid.v4)()}-${stackByField}-${d.key}`),
      scopeId,
      field: stackByField,
      value: d.key
    };
  }) : NO_LEGEND_DATA, [barChart, stackByField, scopeId]);
  const yAxisTitle = (0, _fp.get)('yAxisTitle', configs);
  const customHeight = (0, _fp.get)('customHeight', configs);
  const customWidth = (0, _fp.get)('customWidth', configs);
  const chartHeight = (0, _common.getChartHeight)(customHeight, height);
  const chartWidth = (0, _common.getChartWidth)(customWidth, width);
  const isValidSeriesExist = (0, _react.useMemo)(() => checkIfAnyValidSeriesExist(barChart), [barChart]);
  return /*#__PURE__*/_react.default.createElement(_common.Wrapper, null, /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    targetClassNames: [_utils3.VISUALIZATION_ACTIONS_BUTTON_CLASS]
  }, isValidSeriesExist && barChart && /*#__PURE__*/_react.default.createElement(_common.BarChartWrapper, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_common.WrappedByAutoSizer, {
    ref: measureRef,
    height: chartHeight
  }, /*#__PURE__*/_react.default.createElement(BarChartBase, {
    configs: configs,
    data: barChart,
    yAxisTitle: yAxisTitle,
    forceHiddenLegend: stackByField != null,
    height: chartHeight,
    width: chartHeight
  }))), /*#__PURE__*/_react.default.createElement(LegendFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggable_legend.DraggableLegend, {
    legendItems: legendItems,
    height: height
  }))), !isValidSeriesExist && /*#__PURE__*/_react.default.createElement(_chart_place_holder.ChartPlaceHolder, {
    height: chartHeight,
    width: chartWidth,
    data: barChart
  }), visualizationActionsOptions != null && /*#__PURE__*/_react.default.createElement(_actions.VisualizationActions, (0, _extends2.default)({}, visualizationActionsOptions, {
    className: "viz-actions"
  }))));
};
exports.BarChartComponent = BarChartComponent;
const BarChart = /*#__PURE__*/_react.default.memo(BarChartComponent, (prevProps, nextProps) => prevProps.stackByField === nextProps.stackByField && prevProps.scopeId === nextProps.scopeId && (0, _fastDeepEqual.default)(prevProps.configs, nextProps.configs) && (0, _fastDeepEqual.default)(prevProps.barChart, nextProps.barChart));
exports.BarChart = BarChart;