"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/cloud-security-posture-plugin/public");
var _public2 = require("@kbn/usage-collection-plugin/public");
var _kibana = require("../common/lib/kibana");
var _page_wrapper = require("../common/components/page_wrapper");
var _spy_routes = require("../common/utils/route/spy_routes");
var _filters_global = require("../common/components/filters_global");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This exists only for the type signature cast
const CloudPostureSpyRoute = ({
  pageName,
  ...rest
}) => /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, (0, _extends2.default)({
  pageName: pageName
}, rest));
const cspSecuritySolutionContext = {
  getFiltersGlobalComponent: () => _filters_global.FiltersGlobal,
  getSpyRouteComponent: () => CloudPostureSpyRoute
};
const CloudSecurityPosture = () => {
  const {
    cloudSecurityPosture
  } = (0, _kibana.useKibana)().services;
  const CloudSecurityPostureRouter = cloudSecurityPosture.getCloudSecurityPostureRouter();
  return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public2.TrackApplicationView, {
    viewId: "cloud_security_posture"
  }, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: true,
    noTimeline: true
  }, /*#__PURE__*/_react.default.createElement(CloudSecurityPostureRouter, {
    securitySolutionContext: cspSecuritySolutionContext
  }))));
};
CloudSecurityPosture.displayName = 'CloudSecurityPosture';
const routes = [{
  path: _public.CLOUD_SECURITY_POSTURE_BASE_PATH,
  component: CloudSecurityPosture
}];
exports.routes = routes;