"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rootLinks = exports.manageLinks = exports.manageCategories = exports.dashboardLinks = void 0;
var _public = require("@kbn/cloud-security-posture-plugin/public");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _cloud_security_posture_dashboard_page = _interopRequireDefault(require("../common/images/cloud_security_posture_dashboard_page.png"));
var _exception_lists = require("../management/icons/exception_lists");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const commonLinkProperties = {
  hideTimeline: true,
  capabilities: [`${_constants.SERVER_APP_ID}.show`]
};
const rootLinks = {
  ...(0, _public.getSecuritySolutionLink)('findings'),
  globalNavPosition: 3,
  ...commonLinkProperties
};
exports.rootLinks = rootLinks;
const dashboardLinks = {
  ...(0, _public.getSecuritySolutionLink)('dashboard'),
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.cloudSecurityPostureDashboardDescription', {
    defaultMessage: 'An overview of findings across all CSP integrations.'
  }),
  landingImage: _cloud_security_posture_dashboard_page.default,
  ...commonLinkProperties
};
exports.dashboardLinks = dashboardLinks;
const manageLinks = {
  ...(0, _public.getSecuritySolutionLink)('benchmarks'),
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.cloudSecurityPostureBenchmarksDescription', {
    defaultMessage: 'View benchmark rules.'
  }),
  landingIcon: _exception_lists.IconExceptionLists,
  ...commonLinkProperties
};
exports.manageLinks = manageLinks;
const manageCategories = [{
  label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.cloudSecurityPosture', {
    defaultMessage: 'CLOUD SECURITY'
  }),
  linkIds: [_constants.SecurityPageName.cloudSecurityPostureBenchmarks, _constants.SecurityPageName.cloudDefendPolicies]
}];
exports.manageCategories = manageCategories;