"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConversationStore = void 0;
var _local_storage = require("../../common/components/local_storage");
var _helpers = require("../helpers");
var _conversations = require("../content/conversations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useConversationStore = () => {
  const [conversations, setConversations] = (0, _local_storage.useLocalStorage)({
    defaultValue: _conversations.BASE_SECURITY_CONVERSATIONS,
    key: _helpers.LOCAL_STORAGE_KEY,
    isInvalidDefault: valueFromStorage => {
      return !valueFromStorage;
    }
  });
  return {
    conversations,
    setConversations
  };
};
exports.useConversationStore = useConversationStore;