"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPromptContextFromEventDetailsItem = exports.getPromptContextFromDetectionRules = exports.getFieldsAsCsv = exports.getAllFields = exports.augmentMessageCodeBlocks = exports.SECURITY_ASSISTANT_UI_SETTING_KEY = exports.LOCAL_STORAGE_KEY = void 0;
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react = _interopRequireDefault(require("react"));
var _send_to_timeline = require("./send_to_timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_STORAGE_KEY = `securityAssistant`;
exports.LOCAL_STORAGE_KEY = LOCAL_STORAGE_KEY;
const SECURITY_ASSISTANT_UI_SETTING_KEY = 'securityAssistant';
exports.SECURITY_ASSISTANT_UI_SETTING_KEY = SECURITY_ASSISTANT_UI_SETTING_KEY;
const getPromptContextFromDetectionRules = rules => {
  const data = rules.map(rule => `Rule Name:${rule.name}\nRule Description:${rule.description}`);
  return data.join('\n\n');
};
exports.getPromptContextFromDetectionRules = getPromptContextFromDetectionRules;
const getAllFields = data => data.filter(({
  field
}) => !field.startsWith('signal.')).map(({
  field,
  values
}) => {
  var _values$join;
  return {
    field,
    values: (_values$join = values === null || values === void 0 ? void 0 : values.join(',')) !== null && _values$join !== void 0 ? _values$join : ''
  };
});
exports.getAllFields = getAllFields;
const getFieldsAsCsv = queryFields => queryFields.map(({
  field,
  values
}) => `${field},${values}`).join('\n');
exports.getFieldsAsCsv = getFieldsAsCsv;
const getPromptContextFromEventDetailsItem = data => {
  const allFields = getAllFields(data);
  return getFieldsAsCsv(allFields);
};

/**
 * Augments the messages in a conversation with code block details, including
 * the start and end indices of the code block in the message, the type of the
 * code block, and the button to add the code block to the timeline.
 *
 * @param currentConversation
 */
exports.getPromptContextFromEventDetailsItem = getPromptContextFromEventDetailsItem;
const augmentMessageCodeBlocks = currentConversation => {
  const cbd = currentConversation.messages.map(({
    content
  }) => (0, _elasticAssistant.analyzeMarkdown)(content));
  return cbd.map((codeBlocks, messageIndex) => codeBlocks.map((codeBlock, codeBlockIndex) => {
    var _codeBlock$content;
    return {
      ...codeBlock,
      controlContainer: document.querySelectorAll(`.message-${messageIndex} .euiCodeBlock__controls`)[codeBlockIndex],
      button: /*#__PURE__*/_react.default.createElement(_send_to_timeline.SendToTimelineButton, {
        asEmptyButton: true,
        dataProviders: [{
          id: 'assistant-data-provider',
          name: `Assistant Query from conversation ${currentConversation.id}`,
          enabled: true,
          excluded: false,
          queryType: codeBlock.type,
          kqlQuery: (_codeBlock$content = codeBlock.content) !== null && _codeBlock$content !== void 0 ? _codeBlock$content : '',
          queryMatch: {
            field: 'host.name',
            operator: ':',
            value: 'test'
          },
          and: []
        }],
        keepDataView: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "right",
        content: 'Add to timeline'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "timeline"
      })))
    };
  }));
};
exports.augmentMessageCodeBlocks = augmentMessageCodeBlocks;