"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getComments = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _comment_actions = require("../comment_actions");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getComments = ({
  currentConversation,
  lastCommentRef
}) => currentConversation.messages.map((message, index) => {
  const isUser = message.role === 'user';
  return {
    actions: /*#__PURE__*/_react.default.createElement(_comment_actions.CommentActions, {
      message: message
    }),
    children: index !== currentConversation.messages.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      className: `message-${index}`
    }, message.content)) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      className: `message-${index}`
    }, message.content), /*#__PURE__*/_react.default.createElement("span", {
      ref: lastCommentRef
    })),
    timelineAvatar: isUser ? /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      name: "user",
      size: "l",
      color: "subdued",
      iconType: "userAvatar"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      name: "machine",
      size: "l",
      color: "subdued",
      iconType: "logoSecurity"
    }),
    timestamp: i18n.AT(message.timestamp),
    username: isUser ? i18n.YOU : i18n.ASSISTANT
  };
});
exports.getComments = getComments;