"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BASE_SECURITY_CONVERSATIONS = void 0;
var _translations = require("@kbn/elastic-assistant/impl/assistant/use_conversation/translations");
var _translations2 = require("@kbn/elastic-assistant/impl/content/prompts/welcome/translations");
var _translations3 = require("@kbn/ecs-data-quality-dashboard/impl/data_quality/data_quality_panel/tabs/summary_tab/callout_summary/translations");
var _translations4 = require("../../../detections/pages/detection_engine/rules/translations");
var _translations5 = require("../../../common/components/event_details/translations");
var _translations6 = require("../../comment_actions/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASE_SECURITY_CONVERSATIONS = {
  [_translations5.ALERT_SUMMARY_CONVERSATION_ID]: {
    id: _translations5.ALERT_SUMMARY_CONVERSATION_ID,
    messages: [],
    apiConfig: {}
  },
  [_translations3.DATA_QUALITY_DASHBOARD_CONVERSATION_ID]: {
    id: _translations3.DATA_QUALITY_DASHBOARD_CONVERSATION_ID,
    messages: [],
    apiConfig: {}
  },
  [_translations4.DETECTION_RULES_CONVERSATION_ID]: {
    id: _translations4.DETECTION_RULES_CONVERSATION_ID,
    messages: [],
    apiConfig: {}
  },
  [_translations5.EVENT_SUMMARY_CONVERSATION_ID]: {
    id: _translations5.EVENT_SUMMARY_CONVERSATION_ID,
    messages: [],
    apiConfig: {}
  },
  [_translations.WELCOME_CONVERSATION_TITLE]: {
    id: _translations.WELCOME_CONVERSATION_TITLE,
    theme: {
      title: _translations.ELASTIC_SECURITY_ASSISTANT_TITLE,
      titleIcon: 'logoSecurity',
      assistant: {
        name: _translations6.ELASTIC_SECURITY_ASSISTANT,
        icon: 'logoSecurity'
      },
      system: {
        icon: 'logoElastic'
      },
      user: {}
    },
    messages: [{
      role: 'assistant',
      content: _translations2.WELCOME_GENERAL,
      timestamp: '',
      presentation: {
        delay: 2 * 1000,
        stream: true
      }
    }, {
      role: 'assistant',
      content: _translations2.WELCOME_GENERAL_2,
      timestamp: '',
      presentation: {
        delay: 1000,
        stream: true
      }
    }, {
      role: 'assistant',
      content: _translations2.WELCOME_GENERAL_3,
      timestamp: '',
      presentation: {
        delay: 1000,
        stream: true
      }
    }],
    apiConfig: {}
  }
};
exports.BASE_SECURITY_CONVERSATIONS = BASE_SECURITY_CONVERSATIONS;