"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommentActions = void 0;
var _eui = require("@elastic/eui");
var _common = require("@kbn/cases-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _kibana = require("../../common/lib/kibana");
var _actions = require("../../common/store/actions");
var _types = require("../../../common/types");
var _helpers = require("../../timelines/components/notes/helpers");
var _timeline = require("../../timelines/store/timeline");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommentActionsComponent = ({
  message
}) => {
  const toasts = (0, _kibana.useToasts)();
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const dispatch = (0, _reactRedux.useDispatch)();
  const associateNote = (0, _react.useCallback)(noteId => dispatch(_timeline.timelineActions.addNote({
    id: _types.TimelineId.active,
    noteId
  })), [dispatch]);
  const updateNote = (0, _react.useCallback)(note => dispatch(_actions.appActions.updateNote({
    note
  })), [dispatch]);
  const onAddNoteToTimeline = (0, _react.useCallback)(() => {
    (0, _helpers.updateAndAssociateNode)({
      associateNote,
      newNote: message.content,
      updateNewNote: () => {},
      updateNote,
      user: '' // TODO: attribute assistant messages
    });

    toasts.addSuccess(i18n.ADDED_NOTE_TO_TIMELINE);
  }, [associateNote, message.content, toasts, updateNote]);

  // Attach to case support
  const selectCaseModal = cases.hooks.useCasesAddToExistingCaseModal({
    onClose: () => {},
    onSuccess: () => {}
  });
  const onAddToExistingCase = (0, _react.useCallback)(() => {
    selectCaseModal.open({
      getAttachments: () => [{
        comment: message.content,
        type: _common.CommentType.user,
        owner: i18n.ELASTIC_SECURITY_ASSISTANT
      }]
    });
  }, [message.content, selectCaseModal]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18n.ADD_NOTE_TO_TIMELINE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.ADD_MESSAGE_CONTENT_AS_TIMELINE_NOTE,
    color: "primary",
    iconType: "editorComment",
    onClick: onAddNoteToTimeline
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18n.ADD_TO_CASE_EXISTING_CASE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.ADD_TO_CASE_EXISTING_CASE,
    color: "primary",
    iconType: "addDataApp",
    onClick: onAddToExistingCase
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18n.COPY_TO_CLIPBOARD
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: message.content
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.COPY_TO_CLIPBOARD,
    color: "primary",
    iconType: "copyClipboard",
    onClick: copy
  }))));
};
const CommentActions = /*#__PURE__*/_react.default.memo(CommentActionsComponent);
exports.CommentActions = CommentActions;