"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _ = require("./404");
var _app = require("./app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderApp = ({
  element,
  history,
  onAppLeave,
  setHeaderActionMenu,
  services,
  store,
  usageCollection,
  subPluginRoutes,
  theme$
}) => {
  var _usageCollection$comp;
  const ApplicationUsageTrackingProvider = (_usageCollection$comp = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.components.ApplicationUsageTrackingProvider) !== null && _usageCollection$comp !== void 0 ? _usageCollection$comp : _react.default.Fragment;
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_app.SecurityApp, {
    history: history,
    onAppLeave: onAppLeave,
    services: services,
    setHeaderActionMenu: setHeaderActionMenu,
    store: store,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(ApplicationUsageTrackingProvider, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, subPluginRoutes.map((route, index) => {
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, (0, _extends2.default)({
      key: `route-${index}`
    }, route));
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_.NotFoundPage, null))))), element);
  return () => {
    services.data.search.session.clear();
    (0, _reactDom.unmountComponentAtNode)(element);
  };
};
exports.renderApp = renderApp;