"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HomePage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _drag_drop_context_wrapper = require("../../common/components/drag_and_drop/drag_drop_context_wrapper");
var _page = require("../../common/components/page");
var _help_menu = require("../../common/components/help_menu");
var _sourcerer = require("../../common/containers/sourcerer");
var _global_header = require("./global_header");
var _console_manager = require("../../management/components/console/components/console_manager");
var _guided_onboarding_tour = require("../../common/components/guided_onboarding_tour");
var _use_url_state = require("../../common/hooks/use_url_state");
var _use_update_browser_title = require("../../common/hooks/use_update_browser_title");
var _use_upgrade_security_packages = require("../../detection_engine/rule_management/logic/use_upgrade_security_packages");
var _use_update_execution_context = require("../../common/hooks/use_update_execution_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HomePageComponent = ({
  children,
  setHeaderActionMenu
}) => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  (0, _sourcerer.useInitSourcerer)((0, _sourcerer.getScopeFromPath)(pathname));
  (0, _use_url_state.useUrlState)();
  (0, _use_update_browser_title.useUpdateBrowserTitle)();
  (0, _use_update_execution_context.useUpdateExecutionContext)();
  const {
    browserFields
  } = (0, _sourcerer.useSourcererDataView)((0, _sourcerer.getScopeFromPath)(pathname));
  // side effect: this will attempt to upgrade the endpoint package if it is not up to date
  // this will run when a user navigates to the Security Solution app and when they navigate between
  // tabs in the app. This is useful for keeping the endpoint package as up to date as possible until
  // a background task solution can be built on the server side. Once a background task solution is available we
  // can remove this.
  (0, _use_upgrade_security_packages.useUpgradeSecurityPackages)();
  return /*#__PURE__*/_react.default.createElement(_page.SecuritySolutionAppWrapper, {
    id: "security-solution-app",
    className: "kbnAppWrapper"
  }, /*#__PURE__*/_react.default.createElement(_console_manager.ConsoleManager, null, /*#__PURE__*/_react.default.createElement(_guided_onboarding_tour.TourContextProvider, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_global_header.GlobalHeader, {
    setHeaderActionMenu: setHeaderActionMenu
  }), /*#__PURE__*/_react.default.createElement(_drag_drop_context_wrapper.DragDropContextWrapper, {
    browserFields: browserFields
  }, children), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, null)))));
};
HomePageComponent.displayName = 'HomePage';
const HomePage = /*#__PURE__*/_react.default.memo(HomePageComponent);
exports.HomePage = HomePage;