"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securityNavGroup = exports.navTabs = void 0;
var _public = require("@kbn/cloud-security-posture-plugin/public");
var _public2 = require("@kbn/threat-intelligence-plugin/public");
var _public3 = require("@kbn/cloud-defend-plugin/public");
var i18n = _interopRequireWildcard(require("../translations"));
var _types = require("../../common/components/navigation/types");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const navTabs = {
  [_constants.SecurityPageName.landing]: {
    id: _constants.SecurityPageName.landing,
    name: i18n.GETTING_STARTED,
    href: _constants.APP_LANDING_PATH,
    disabled: false,
    urlKey: 'get_started'
  },
  [_constants.SecurityPageName.overview]: {
    id: _constants.SecurityPageName.overview,
    name: i18n.OVERVIEW,
    href: _constants.APP_OVERVIEW_PATH,
    disabled: false,
    urlKey: 'overview'
  },
  [_constants.SecurityPageName.detectionAndResponse]: {
    id: _constants.SecurityPageName.detectionAndResponse,
    name: i18n.DETECTION_RESPONSE,
    href: _constants.APP_DETECTION_RESPONSE_PATH,
    disabled: false,
    urlKey: 'detection_response'
  },
  [_constants.SecurityPageName.alerts]: {
    id: _constants.SecurityPageName.alerts,
    name: i18n.ALERTS,
    href: _constants.APP_ALERTS_PATH,
    disabled: false,
    urlKey: 'alerts'
  },
  [_constants.SecurityPageName.rules]: {
    id: _constants.SecurityPageName.rules,
    name: i18n.RULES,
    href: _constants.APP_RULES_PATH,
    disabled: false,
    urlKey: 'rules'
  },
  [_constants.SecurityPageName.exceptions]: {
    id: _constants.SecurityPageName.exceptions,
    name: i18n.EXCEPTIONS,
    href: _constants.APP_EXCEPTIONS_PATH,
    disabled: false,
    urlKey: 'exceptions'
  },
  [_constants.SecurityPageName.hosts]: {
    id: _constants.SecurityPageName.hosts,
    name: i18n.HOSTS,
    href: _constants.APP_HOSTS_PATH,
    disabled: false,
    urlKey: 'host'
  },
  [_constants.SecurityPageName.users]: {
    id: _constants.SecurityPageName.users,
    name: i18n.USERS,
    href: _constants.APP_USERS_PATH,
    disabled: false,
    urlKey: 'users'
  },
  [_constants.SecurityPageName.network]: {
    id: _constants.SecurityPageName.network,
    name: i18n.NETWORK,
    href: _constants.APP_NETWORK_PATH,
    disabled: false,
    urlKey: 'network'
  },
  [_constants.SecurityPageName.kubernetes]: {
    id: _constants.SecurityPageName.kubernetes,
    name: i18n.KUBERNETES,
    href: _constants.APP_KUBERNETES_PATH,
    disabled: false,
    urlKey: 'kubernetes'
  },
  [_constants.SecurityPageName.timelines]: {
    id: _constants.SecurityPageName.timelines,
    name: i18n.TIMELINES,
    href: _constants.APP_TIMELINES_PATH,
    disabled: false,
    urlKey: 'timeline'
  },
  [_constants.SecurityPageName.case]: {
    id: _constants.SecurityPageName.case,
    name: i18n.CASE,
    href: _constants.APP_CASES_PATH,
    disabled: false,
    urlKey: 'cases'
  },
  [_constants.SecurityPageName.endpoints]: {
    id: _constants.SecurityPageName.endpoints,
    name: i18n.ENDPOINTS,
    href: _constants.APP_ENDPOINTS_PATH,
    disabled: false,
    urlKey: 'administration'
  },
  [_constants.SecurityPageName.policies]: {
    id: _constants.SecurityPageName.policies,
    name: i18n.POLICIES,
    href: _constants.APP_POLICIES_PATH,
    disabled: false,
    urlKey: 'administration'
  },
  [_constants.SecurityPageName.trustedApps]: {
    id: _constants.SecurityPageName.trustedApps,
    name: i18n.TRUSTED_APPLICATIONS,
    href: _constants.APP_TRUSTED_APPS_PATH,
    disabled: false,
    urlKey: 'administration'
  },
  [_constants.SecurityPageName.eventFilters]: {
    id: _constants.SecurityPageName.eventFilters,
    name: i18n.EVENT_FILTERS,
    href: _constants.APP_EVENT_FILTERS_PATH,
    disabled: false,
    urlKey: 'administration'
  },
  [_constants.SecurityPageName.hostIsolationExceptions]: {
    id: _constants.SecurityPageName.hostIsolationExceptions,
    name: i18n.HOST_ISOLATION_EXCEPTIONS,
    href: _constants.APP_HOST_ISOLATION_EXCEPTIONS_PATH,
    disabled: false,
    urlKey: 'administration'
  },
  [_constants.SecurityPageName.blocklist]: {
    id: _constants.SecurityPageName.blocklist,
    name: i18n.BLOCKLIST,
    href: _constants.APP_BLOCKLIST_PATH,
    disabled: false,
    urlKey: 'administration'
  },
  [_constants.SecurityPageName.responseActionsHistory]: {
    id: _constants.SecurityPageName.responseActionsHistory,
    name: i18n.RESPONSE_ACTIONS_HISTORY,
    href: _constants.APP_RESPONSE_ACTIONS_HISTORY_PATH,
    disabled: false,
    urlKey: 'administration'
  },
  [_constants.SecurityPageName.threatIntelligenceIndicators]: {
    ...(0, _public2.getSecuritySolutionNavTab)('indicators', _constants.APP_PATH),
    urlKey: 'indicators'
  },
  [_constants.SecurityPageName.cloudSecurityPostureFindings]: {
    ...(0, _public.getSecuritySolutionNavTab)('findings', _constants.APP_PATH),
    urlKey: 'findings'
  },
  [_constants.SecurityPageName.cloudSecurityPostureDashboard]: {
    ...(0, _public.getSecuritySolutionNavTab)('dashboard', _constants.APP_PATH),
    urlKey: 'cloud_posture'
  },
  [_constants.SecurityPageName.cloudSecurityPostureBenchmarks]: {
    ...(0, _public.getSecuritySolutionNavTab)('benchmarks', _constants.APP_PATH),
    urlKey: 'administration'
  },
  [_constants.SecurityPageName.cloudDefendPolicies]: {
    ...(0, _public3.getSecuritySolutionNavTab)('policies', _constants.APP_PATH),
    urlKey: 'administration'
  },
  [_constants.SecurityPageName.entityAnalytics]: {
    id: _constants.SecurityPageName.entityAnalytics,
    name: i18n.ENTITY_ANALYTICS,
    href: _constants.APP_ENTITY_ANALYTICS_PATH,
    disabled: false,
    urlKey: 'entity_analytics'
  },
  [_constants.SecurityPageName.dataQuality]: {
    id: _constants.SecurityPageName.dataQuality,
    name: i18n.DATA_QUALITY,
    href: _constants.APP_DATA_QUALITY_PATH,
    disabled: false,
    urlKey: 'data_quality'
  }
};
exports.navTabs = navTabs;
const securityNavGroup = {
  [_types.SecurityNavGroupKey.dashboards]: {
    id: _types.SecurityNavGroupKey.dashboards,
    name: i18n.DASHBOARDS
  },
  [_types.SecurityNavGroupKey.detect]: {
    id: _types.SecurityNavGroupKey.detect,
    name: i18n.DETECT
  },
  [_types.SecurityNavGroupKey.findings]: {
    id: _types.SecurityNavGroupKey.findings,
    name: i18n.FINDINGS
  },
  [_types.SecurityNavGroupKey.explore]: {
    id: _types.SecurityNavGroupKey.explore,
    name: i18n.EXPLORE
  },
  [_types.SecurityNavGroupKey.intelligence]: {
    id: _types.SecurityNavGroupKey.intelligence,
    name: i18n.THREAT_INTELLIGENCE
  },
  [_types.SecurityNavGroupKey.investigate]: {
    id: _types.SecurityNavGroupKey.investigate,
    name: i18n.INVESTIGATE
  },
  [_types.SecurityNavGroupKey.manage]: {
    id: _types.SecurityNavGroupKey.manage,
    name: i18n.MANAGE
  }
};
exports.securityNavGroup = securityNavGroup;