"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FEATURE = void 0;
exports.getDeepLinks = getDeepLinks;
exports.hasFeaturesCapability = hasFeaturesCapability;
exports.isPremiumLicense = isPremiumLicense;
exports.securitySolutionsDeepLinks = exports.registerDeepLinksUpdater = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/cloud-defend-plugin/public");
var _public2 = require("@kbn/cloud-security-posture-plugin/public");
var _public3 = require("@kbn/threat-intelligence-plugin/public");
var _public4 = require("@kbn/cases-plugin/public");
var _common = require("@kbn/cases-plugin/common");
var _public5 = require("@kbn/core/public");
var _types = require("../types");
var _translations = require("../translations");
var _constants = require("../../../common/constants");
var _links = require("../../common/links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FEATURE = {
  general: `${_constants.SERVER_APP_ID}.show`,
  casesCreate: `${_constants.CASES_FEATURE_ID}.${_common.CREATE_CASES_CAPABILITY}`,
  casesRead: `${_constants.CASES_FEATURE_ID}.${_common.READ_CASES_CAPABILITY}`,
  casesUpdate: `${_constants.CASES_FEATURE_ID}.${_common.UPDATE_CASES_CAPABILITY}`,
  casesDelete: `${_constants.CASES_FEATURE_ID}.${_common.DELETE_CASES_CAPABILITY}`,
  casesPush: `${_constants.CASES_FEATURE_ID}.${_common.PUSH_CASES_CAPABILITY}`
};
exports.FEATURE = FEATURE;
const securitySolutionsDeepLinks = [{
  id: _types.SecurityPageName.landing,
  title: _translations.GETTING_STARTED,
  path: _constants.LANDING_PATH,
  features: [FEATURE.general],
  keywords: [_i18n.i18n.translate('xpack.securitySolution.search.getStarted', {
    defaultMessage: 'Getting started'
  })]
}, {
  id: _types.SecurityPageName.dashboards,
  title: _translations.DASHBOARDS,
  path: _constants.OVERVIEW_PATH,
  navLinkStatus: _public5.AppNavLinkStatus.visible,
  searchable: false,
  order: 9000,
  features: [FEATURE.general],
  keywords: [_i18n.i18n.translate('xpack.securitySolution.search.dashboards', {
    defaultMessage: 'Dashboards'
  })],
  deepLinks: [{
    id: _types.SecurityPageName.overview,
    title: _translations.OVERVIEW,
    path: _constants.OVERVIEW_PATH,
    features: [FEATURE.general],
    keywords: [_i18n.i18n.translate('xpack.securitySolution.search.overview', {
      defaultMessage: 'Overview'
    })]
  }, {
    id: _types.SecurityPageName.detectionAndResponse,
    title: _translations.DETECTION_RESPONSE,
    path: _constants.DETECTION_RESPONSE_PATH,
    features: [FEATURE.general],
    keywords: [_i18n.i18n.translate('xpack.securitySolution.search.detectionAndResponse', {
      defaultMessage: 'Detection & Response'
    })]
  }, {
    ...(0, _public2.getSecuritySolutionLink)('dashboard'),
    features: [FEATURE.general]
  }, {
    id: _types.SecurityPageName.entityAnalytics,
    title: _translations.ENTITY_ANALYTICS,
    path: _constants.ENTITY_ANALYTICS_PATH,
    features: [FEATURE.general],
    isPremium: true,
    keywords: [_i18n.i18n.translate('xpack.securitySolution.search.entityAnalytics', {
      defaultMessage: 'Entity Analytics'
    })]
  }, {
    id: _types.SecurityPageName.dataQuality,
    title: _translations.DATA_QUALITY,
    path: _constants.DATA_QUALITY_PATH,
    features: [FEATURE.general],
    keywords: [_i18n.i18n.translate('xpack.securitySolution.search.dataQualityDashboard', {
      defaultMessage: 'Data quality'
    })]
  }]
}, {
  id: _types.SecurityPageName.detections,
  title: _translations.DETECT,
  path: _constants.ALERTS_PATH,
  navLinkStatus: _public5.AppNavLinkStatus.hidden,
  features: [FEATURE.general],
  keywords: [_i18n.i18n.translate('xpack.securitySolution.search.detect', {
    defaultMessage: 'Detect'
  })],
  deepLinks: [{
    id: _types.SecurityPageName.alerts,
    title: _translations.ALERTS,
    path: _constants.ALERTS_PATH,
    navLinkStatus: _public5.AppNavLinkStatus.visible,
    order: 9001,
    keywords: [_i18n.i18n.translate('xpack.securitySolution.search.alerts', {
      defaultMessage: 'Alerts'
    })]
  }, {
    id: _types.SecurityPageName.rules,
    title: _translations.RULES,
    path: _constants.RULES_PATH,
    keywords: [_i18n.i18n.translate('xpack.securitySolution.search.rules', {
      defaultMessage: 'Rules'
    })],
    deepLinks: [{
      id: _types.SecurityPageName.rulesCreate,
      title: _translations.CREATE_NEW_RULE,
      path: _constants.RULES_CREATE_PATH,
      navLinkStatus: _public5.AppNavLinkStatus.hidden,
      searchable: false
    }]
  }, {
    id: _types.SecurityPageName.exceptions,
    title: _translations.EXCEPTIONS,
    path: _constants.EXCEPTIONS_PATH,
    keywords: [_i18n.i18n.translate('xpack.securitySolution.search.exceptions', {
      defaultMessage: 'Exception lists'
    })]
  }]
}, {
  ...(0, _public2.getSecuritySolutionLink)('findings'),
  features: [FEATURE.general],
  navLinkStatus: _public5.AppNavLinkStatus.visible,
  order: 9002
}, {
  id: _types.SecurityPageName.exploreLanding,
  title: _translations.EXPLORE,
  path: _constants.HOSTS_PATH,
  navLinkStatus: _public5.AppNavLinkStatus.visible,
  order: 9005,
  searchable: false,
  features: [FEATURE.general],
  keywords: [_i18n.i18n.translate('xpack.securitySolution.search.explore', {
    defaultMessage: 'Explore'
  })],
  deepLinks: [{
    id: _types.SecurityPageName.hosts,
    title: _translations.HOSTS,
    path: _constants.HOSTS_PATH,
    keywords: [_i18n.i18n.translate('xpack.securitySolution.search.hosts', {
      defaultMessage: 'Hosts'
    })],
    deepLinks: [{
      id: _types.SecurityPageName.uncommonProcesses,
      title: _i18n.i18n.translate('xpack.securitySolution.search.hosts.uncommonProcesses', {
        defaultMessage: 'Uncommon Processes'
      }),
      path: `${_constants.HOSTS_PATH}/uncommonProcesses`
    }, {
      id: _types.SecurityPageName.hostsAnomalies,
      title: _i18n.i18n.translate('xpack.securitySolution.search.hosts.anomalies', {
        defaultMessage: 'Anomalies'
      }),
      path: `${_constants.HOSTS_PATH}/anomalies`,
      isPremium: true
    }, {
      id: _types.SecurityPageName.hostsEvents,
      title: _i18n.i18n.translate('xpack.securitySolution.search.hosts.events', {
        defaultMessage: 'Events'
      }),
      path: `${_constants.HOSTS_PATH}/events`
    }, {
      id: _types.SecurityPageName.hostsRisk,
      title: _i18n.i18n.translate('xpack.securitySolution.search.hosts.risk', {
        defaultMessage: 'Host risk'
      }),
      path: `${_constants.HOSTS_PATH}/hostRisk`
    }, {
      id: _types.SecurityPageName.sessions,
      title: _i18n.i18n.translate('xpack.securitySolution.search.hosts.sessions', {
        defaultMessage: 'Sessions'
      }),
      path: `${_constants.HOSTS_PATH}/sessions`
    }]
  }, {
    id: _types.SecurityPageName.network,
    title: _translations.NETWORK,
    path: _constants.NETWORK_PATH,
    keywords: [_i18n.i18n.translate('xpack.securitySolution.search.network', {
      defaultMessage: 'Network'
    })],
    deepLinks: [{
      id: _types.SecurityPageName.networkDns,
      title: _i18n.i18n.translate('xpack.securitySolution.search.network.dns', {
        defaultMessage: 'DNS'
      }),
      path: `${_constants.NETWORK_PATH}/dns`
    }, {
      id: _types.SecurityPageName.networkHttp,
      title: _i18n.i18n.translate('xpack.securitySolution.search.network.http', {
        defaultMessage: 'HTTP'
      }),
      path: `${_constants.NETWORK_PATH}/http`
    }, {
      id: _types.SecurityPageName.networkTls,
      title: _i18n.i18n.translate('xpack.securitySolution.search.network.tls', {
        defaultMessage: 'TLS'
      }),
      path: `${_constants.NETWORK_PATH}/tls`
    }, {
      id: _types.SecurityPageName.networkAnomalies,
      title: _i18n.i18n.translate('xpack.securitySolution.search.network.anomalies', {
        defaultMessage: 'Anomalies'
      }),
      path: `${_constants.NETWORK_PATH}/anomalies`,
      isPremium: true
    }, {
      id: _types.SecurityPageName.networkEvents,
      title: _i18n.i18n.translate('xpack.securitySolution.search.network.events', {
        defaultMessage: 'Events'
      }),
      path: `${_constants.NETWORK_PATH}/events`
    }]
  }, {
    id: _types.SecurityPageName.users,
    title: _translations.USERS,
    path: _constants.USERS_PATH,
    keywords: [_i18n.i18n.translate('xpack.securitySolution.search.users', {
      defaultMessage: 'Users'
    })],
    deepLinks: [{
      id: _types.SecurityPageName.usersAuthentications,
      title: _i18n.i18n.translate('xpack.securitySolution.search.users.authentications', {
        defaultMessage: 'Authentications'
      }),
      path: `${_constants.USERS_PATH}/authentications`
    }, {
      id: _types.SecurityPageName.usersAnomalies,
      title: _i18n.i18n.translate('xpack.securitySolution.search.users.anomalies', {
        defaultMessage: 'Anomalies'
      }),
      path: `${_constants.USERS_PATH}/anomalies`,
      isPremium: true
    }, {
      id: _types.SecurityPageName.usersRisk,
      title: _i18n.i18n.translate('xpack.securitySolution.search.users.risk', {
        defaultMessage: 'User risk'
      }),
      path: `${_constants.USERS_PATH}/userRisk`
    }, {
      id: _types.SecurityPageName.usersEvents,
      title: _i18n.i18n.translate('xpack.securitySolution.search.users.events', {
        defaultMessage: 'Events'
      }),
      path: `${_constants.USERS_PATH}/events`
    }]
  }, {
    ...(0, _public3.getSecuritySolutionDeepLink)('indicators'),
    navLinkStatus: _public5.AppNavLinkStatus.visible,
    order: 9006,
    features: [FEATURE.general]
  }, {
    id: _types.SecurityPageName.kubernetes,
    title: _translations.KUBERNETES,
    path: _constants.KUBERNETES_PATH,
    experimentalKey: 'kubernetesEnabled',
    keywords: [_i18n.i18n.translate('xpack.securitySolution.search.kubernetes', {
      defaultMessage: 'Kubernetes'
    })]
  }]
}, {
  id: _types.SecurityPageName.investigate,
  title: _translations.INVESTIGATE,
  navLinkStatus: _public5.AppNavLinkStatus.hidden,
  features: [FEATURE.general, FEATURE.casesRead],
  keywords: [_i18n.i18n.translate('xpack.securitySolution.search.investigate', {
    defaultMessage: 'Investigate'
  })],
  deepLinks: [{
    id: _types.SecurityPageName.timelines,
    title: _translations.TIMELINES,
    path: _constants.TIMELINES_PATH,
    navLinkStatus: _public5.AppNavLinkStatus.visible,
    order: 9003,
    features: [FEATURE.general],
    keywords: [_i18n.i18n.translate('xpack.securitySolution.search.timelines', {
      defaultMessage: 'Timelines'
    })],
    deepLinks: [{
      id: _types.SecurityPageName.timelinesTemplates,
      title: _i18n.i18n.translate('xpack.securitySolution.search.timeline.templates', {
        defaultMessage: 'Templates'
      }),
      path: `${_constants.TIMELINES_PATH}/template`
    }]
  }, (0, _public4.getCasesDeepLinks)({
    basePath: _constants.CASES_PATH,
    extend: {
      [_types.SecurityPageName.case]: {
        navLinkStatus: _public5.AppNavLinkStatus.visible,
        order: 9004,
        features: [FEATURE.casesRead]
      },
      [_types.SecurityPageName.caseConfigure]: {
        features: [FEATURE.casesUpdate],
        isPremium: true
      },
      [_types.SecurityPageName.caseCreate]: {
        features: [FEATURE.casesCreate]
      }
    }
  })]
}, {
  id: _types.SecurityPageName.administration,
  title: _translations.MANAGE,
  path: _constants.ENDPOINTS_PATH,
  features: [FEATURE.general],
  navLinkStatus: _public5.AppNavLinkStatus.visible,
  order: 9007,
  searchable: false,
  keywords: [_i18n.i18n.translate('xpack.securitySolution.search.manage', {
    defaultMessage: 'Manage'
  })],
  deepLinks: [{
    id: _types.SecurityPageName.endpoints,
    title: _translations.ENDPOINTS,
    path: _constants.ENDPOINTS_PATH
  }, {
    id: _types.SecurityPageName.policies,
    title: _translations.POLICIES,
    path: _constants.POLICIES_PATH,
    experimentalKey: 'policyListEnabled'
  }, {
    id: _types.SecurityPageName.trustedApps,
    title: _translations.TRUSTED_APPLICATIONS,
    path: _constants.TRUSTED_APPS_PATH
  }, {
    id: _types.SecurityPageName.eventFilters,
    title: _translations.EVENT_FILTERS,
    path: _constants.EVENT_FILTERS_PATH
  }, {
    id: _types.SecurityPageName.hostIsolationExceptions,
    title: _translations.HOST_ISOLATION_EXCEPTIONS,
    path: _constants.HOST_ISOLATION_EXCEPTIONS_PATH
  }, {
    id: _types.SecurityPageName.blocklist,
    title: _translations.BLOCKLIST,
    path: _constants.BLOCKLIST_PATH
  }, {
    id: _types.SecurityPageName.responseActionsHistory,
    title: _translations.RESPONSE_ACTIONS_HISTORY,
    path: _constants.RESPONSE_ACTIONS_HISTORY_PATH
  }, {
    ...(0, _public2.getSecuritySolutionLink)('benchmarks')
  }, {
    ...(0, _public.getSecuritySolutionLink)('policies')
  }]
}];

/**
 * A function that generates the plugin deepLinks structure
 * used by Kibana to build the global side navigation and application search results
 * @param enableExperimental ExperimentalFeatures arg
 * @param licenseType optional string for license level, if not provided basic is assumed.
 * @param capabilities optional arg for app start capabilities
 */
exports.securitySolutionsDeepLinks = securitySolutionsDeepLinks;
function getDeepLinks(enableExperimental, licenseType, capabilities) {
  const filterDeepLinks = securityDeepLinks => securityDeepLinks.reduce((deepLinks, {
    isPremium,
    features,
    experimentalKey,
    hideWhenExperimentalKey,
    ...deepLink
  }) => {
    if (licenseType && isPremium && !isPremiumLicense(licenseType)) {
      return deepLinks;
    }
    if (experimentalKey && !enableExperimental[experimentalKey]) {
      return deepLinks;
    }
    if (hideWhenExperimentalKey && enableExperimental[hideWhenExperimentalKey]) {
      return deepLinks;
    }
    if (capabilities != null && !hasFeaturesCapability(features, capabilities)) {
      return deepLinks;
    }
    if (deepLink.deepLinks) {
      deepLinks.push({
        ...deepLink,
        deepLinks: filterDeepLinks(deepLink.deepLinks)
      });
    } else {
      deepLinks.push(deepLink);
    }
    return deepLinks;
  }, []);
  return filterDeepLinks(securitySolutionsDeepLinks);
}
function hasFeaturesCapability(features, capabilities) {
  if (!features) {
    return true;
  }
  return (0, _links.hasCapabilities)(features, capabilities);
}
function isPremiumLicense(licenseType) {
  return licenseType === 'gold' || licenseType === 'platinum' || licenseType === 'enterprise' || licenseType === 'trial';
}

/**
 * New deep links code starts here.
 * All the code above will be removed once the appLinks migration is over.
 * The code below manages the new implementation using the unified appLinks.
 */

const formatDeepLinks = appLinks => appLinks.map(appLink => {
  var _appLink$links;
  return {
    id: appLink.id,
    path: appLink.path,
    title: appLink.title,
    searchable: !appLink.globalSearchDisabled,
    ...(appLink.globalNavPosition != null ? {
      navLinkStatus: _public5.AppNavLinkStatus.visible,
      order: appLink.globalNavPosition
    } : {
      navLinkStatus: _public5.AppNavLinkStatus.hidden
    }),
    ...(appLink.globalSearchKeywords != null ? {
      keywords: appLink.globalSearchKeywords
    } : {}),
    ...(appLink.links && (_appLink$links = appLink.links) !== null && _appLink$links !== void 0 && _appLink$links.length ? {
      deepLinks: formatDeepLinks(appLink.links)
    } : {})
  };
});

/**
 * Registers any change in appLinks to be updated in app deepLinks
 */
const registerDeepLinksUpdater = appUpdater$ => {
  return (0, _links.subscribeAppLinks)(appLinks => {
    appUpdater$.next(() => ({
      navLinkStatus: _public5.AppNavLinkStatus.hidden,
      // needed to prevent main security link to switch to visible after update
      deepLinks: formatDeepLinks(appLinks)
    }));
  });
};
exports.registerDeepLinksUpdater = registerDeepLinksUpdater;