"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createToggleColumnCellActionFactory = void 0;
var _i18n = require("@kbn/i18n");
var _cellActions = require("@kbn/cell-actions");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _utils = require("../../utils");
var _helpers = require("../../../helpers");
var _defaults = require("../../../timelines/store/timeline/defaults");
var _timeline = require("../../../timelines/store/timeline");
var _constants = require("../../../timelines/components/timeline/body/constants");
var _constants2 = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ICON = 'listAdd';
const COLUMN_TOGGLE = _i18n.i18n.translate('xpack.securitySolution.actions.toggleColumnToggle.label', {
  defaultMessage: 'Toggle column in table'
});
const NESTED_COLUMN = field => _i18n.i18n.translate('xpack.securitySolution.actions.toggleColumnToggle.nestedLabel', {
  values: {
    field
  },
  defaultMessage: 'The {field} field is an object, and is broken down into nested fields which can be added as columns'
});
const createToggleColumnCellActionFactory = (0, _cellActions.createCellActionFactory)(({
  store
}) => ({
  type: _constants2.SecurityCellActionType.TOGGLE_COLUMN,
  getIconType: () => ICON,
  getDisplayName: () => COLUMN_TOGGLE,
  getDisplayNameTooltip: ({
    field,
    metadata
  }) => metadata !== null && metadata !== void 0 && metadata.isObjectArray ? NESTED_COLUMN(field.name) : COLUMN_TOGGLE,
  isCompatible: async ({
    field,
    metadata
  }) => {
    return (0, _utils.fieldHasCellActions)(field.name) && !!(metadata !== null && metadata !== void 0 && metadata.scopeId) && ((0, _helpers.isTimelineScope)(metadata.scopeId) || (0, _helpers.isInTableScope)(metadata.scopeId));
  },
  execute: async ({
    metadata,
    field
  }) => {
    var _selector;
    const scopeId = metadata === null || metadata === void 0 ? void 0 : metadata.scopeId;
    if (!scopeId) return;
    const scopedActions = (0, _helpers.getScopedActions)(scopeId);
    if (!scopedActions) {
      return;
    }
    const selector = (0, _helpers.isTimelineScope)(scopeId) ? _timeline.timelineSelectors.getTimelineByIdSelector() : _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();
    const defaults = (0, _helpers.isTimelineScope)(scopeId) ? _defaults.timelineDefaults : _securitysolutionDataTable.tableDefaults;
    const {
      columns
    } = (_selector = selector(store.getState(), scopeId)) !== null && _selector !== void 0 ? _selector : defaults;
    if (columns.some(c => c.id === field.name)) {
      store.dispatch(scopedActions.removeColumn({
        columnId: field.name,
        id: scopeId
      }));
    } else {
      store.dispatch(scopedActions.upsertColumn({
        column: {
          columnHeaderType: _securitysolutionDataTable.defaultColumnHeaderType,
          id: field.name,
          initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
        },
        id: scopeId,
        index: 1
      }));
    }
  }
}));
exports.createToggleColumnCellActionFactory = createToggleColumnCellActionFactory;