"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enhanceActionWithTelemetry = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const enhanceActionWithTelemetry = (action, services) => {
  const {
    telemetry
  } = services;
  const {
    execute,
    ...rest
  } = action;
  const enhancedExecute = context => {
    telemetry.reportCellActionClicked({
      actionId: rest.id,
      displayName: rest.getDisplayName(context),
      fieldName: context.field.name,
      metadata: context.metadata
    });
    return execute(context);
  };
  return {
    ...rest,
    execute: enhancedExecute
  };
};
exports.enhanceActionWithTelemetry = enhanceActionWithTelemetry;