"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createShowTopNCellActionFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireWildcard(require("react-dom"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _cellActions = require("@kbn/cell-actions");
var _common = require("@kbn/kibana-react-plugin/common");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/constants");
var _utils = require("../../utils");
var _show_top_n_component = require("../show_top_n_component");
var _constants2 = require("../../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHOW_TOP = fieldName => _i18n.i18n.translate('xpack.securitySolution.actions.showTopTooltip', {
  values: {
    fieldName
  },
  defaultMessage: `Show top {fieldName}`
});
const ICON = 'visBarVertical';
const UNSUPPORTED_FIELD_TYPES = ['date', 'text'];
const createShowTopNCellActionFactory = (0, _cellActions.createCellActionFactory)(({
  store,
  history,
  services
}) => ({
  type: _constants2.SecurityCellActionType.SHOW_TOP_N,
  getIconType: () => ICON,
  getDisplayName: ({
    field
  }) => SHOW_TOP(field.name),
  getDisplayNameTooltip: ({
    field
  }) => SHOW_TOP(field.name),
  isCompatible: async ({
    field
  }) => (0, _utils.fieldHasCellActions)(field.name) && !UNSUPPORTED_FIELD_TYPES.includes(field.type) && !!field.aggregatable,
  execute: async context => {
    if (!context.nodeRef.current) return;
    const node = document.createElement('div');
    document.body.appendChild(node);
    const onClose = () => {
      (0, _reactDom.unmountComponentAtNode)(node);
      document.body.removeChild(node);
    };
    const element = /*#__PURE__*/_react.default.createElement(_kibana.KibanaContextProvider, {
      services: {
        appName: _constants.APP_NAME,
        ...services
      }
    }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
      darkMode: services.uiSettings.get(_constants.DEFAULT_DARK_MODE)
    }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
      store: store
    }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
      history: history
    }, /*#__PURE__*/_react.default.createElement(_show_top_n_component.TopNAction, {
      onClose: onClose,
      context: context,
      casesService: services.cases
    })))));
    _reactDom.default.render(element, node);
  }
}));
exports.createShowTopNCellActionFactory = createShowTopNCellActionFactory;