"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEndpointPackageInfo = void 0;
var _common = require("@kbn/fleet-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEndpointPackageInfo = async kbnClient => {
  const path = _common.epmRouteService.getInfoPath('endpoint');
  const endpointPackage = (await kbnClient.request({
    path,
    method: 'GET'
  })).data.item;
  if (!endpointPackage) {
    throw new Error('EPM Endpoint package was not found!');
  }
  return endpointPackage;
};
exports.getEndpointPackageInfo = getEndpointPackageInfo;