"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.commandToRBACMap = exports.RESPONSE_ACTION_STATUS = exports.RESPONSE_ACTION_API_COMMANDS_TO_CONSOLE_COMMAND_MAP = exports.RESPONSE_ACTION_API_COMMANDS_NAMES = exports.ENDPOINT_CAPABILITIES = exports.ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS = exports.DEFAULT_EXECUTE_ACTION_TIMEOUT = exports.CONSOLE_RESPONSE_ACTION_COMMANDS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RESPONSE_ACTION_STATUS = ['failed', 'pending', 'successful'];
exports.RESPONSE_ACTION_STATUS = RESPONSE_ACTION_STATUS;
/**
 * The Command names that are used in the API payload for the `{ command: '' }` attribute
 */
const RESPONSE_ACTION_API_COMMANDS_NAMES = ['isolate', 'unisolate', 'kill-process', 'suspend-process', 'running-processes', 'get-file', 'execute'];
exports.RESPONSE_ACTION_API_COMMANDS_NAMES = RESPONSE_ACTION_API_COMMANDS_NAMES;
const ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS = ['isolate'];

/**
 * The list of possible capabilities, reported by the endpoint in the metadata document
 */
exports.ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS = ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS;
const ENDPOINT_CAPABILITIES = ['isolation', 'kill_process', 'suspend_process', 'running_processes', 'get_file', 'execute'];
exports.ENDPOINT_CAPABILITIES = ENDPOINT_CAPABILITIES;
/**
 * The list of possible console command names that generate a Response Action to be dispatched
 * to the Endpoint. (FYI: not all console commands are response actions)
 */
const CONSOLE_RESPONSE_ACTION_COMMANDS = ['isolate', 'release', 'kill-process', 'suspend-process', 'processes', 'get-file', 'execute'];
exports.CONSOLE_RESPONSE_ACTION_COMMANDS = CONSOLE_RESPONSE_ACTION_COMMANDS;
/**
 * maps the console command to the RBAC control that is required to access it via console
 */
const commandToRBACMap = Object.freeze({
  isolate: 'writeHostIsolation',
  release: 'writeHostIsolation',
  'kill-process': 'writeProcessOperations',
  'suspend-process': 'writeProcessOperations',
  processes: 'writeProcessOperations',
  'get-file': 'writeFileOperations',
  execute: 'writeExecuteOperations'
});
exports.commandToRBACMap = commandToRBACMap;
const RESPONSE_ACTION_API_COMMANDS_TO_CONSOLE_COMMAND_MAP = Object.freeze({
  isolate: 'isolate',
  unisolate: 'release',
  execute: 'execute',
  'get-file': 'get-file',
  'running-processes': 'processes',
  'kill-process': 'kill-process',
  'suspend-process': 'suspend-process'
});

// 4 hrs in seconds
// 4 * 60 * 60
exports.RESPONSE_ACTION_API_COMMANDS_TO_CONSOLE_COMMAND_MAP = RESPONSE_ACTION_API_COMMANDS_TO_CONSOLE_COMMAND_MAP;
const DEFAULT_EXECUTE_ACTION_TIMEOUT = 14400;
exports.DEFAULT_EXECUTE_ACTION_TIMEOUT = DEFAULT_EXECUTE_ACTION_TIMEOUT;