"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleExecutionResultsUrl = exports.getRuleExecutionEventsUrl = exports.GET_SPACE_HEALTH_URL = exports.GET_RULE_HEALTH_URL = exports.GET_RULE_EXECUTION_RESULTS_URL = exports.GET_RULE_EXECUTION_EVENTS_URL = exports.GET_CLUSTER_HEALTH_URL = void 0;
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// -------------------------------------------------------------------------------------------------
// Detection Engine health API

/**
 * Get health overview of the whole cluster. Scope: all detection rules in all Kibana spaces.
 * See the corresponding route handler for more details.
 */
const GET_CLUSTER_HEALTH_URL = `${_constants.INTERNAL_DETECTION_ENGINE_URL}/health/_cluster`;

/**
 * Get health overview of the current Kibana space. Scope: all detection rules in the space.
 * See the corresponding route handler for more details.
 */
exports.GET_CLUSTER_HEALTH_URL = GET_CLUSTER_HEALTH_URL;
const GET_SPACE_HEALTH_URL = `${_constants.INTERNAL_DETECTION_ENGINE_URL}/health/_space`;

/**
 * Get health overview of a rule. Scope: a given detection rule in the current Kibana space.
 * See the corresponding route handler for more details.
 */
exports.GET_SPACE_HEALTH_URL = GET_SPACE_HEALTH_URL;
const GET_RULE_HEALTH_URL = `${_constants.INTERNAL_DETECTION_ENGINE_URL}/health/_rule`;

// -------------------------------------------------------------------------------------------------
// Rule execution logs API

/**
 * Get plain individual rule execution events, such as status changes, execution metrics,
 * log messages, etc.
 */
exports.GET_RULE_HEALTH_URL = GET_RULE_HEALTH_URL;
const GET_RULE_EXECUTION_EVENTS_URL = `${_constants.INTERNAL_DETECTION_ENGINE_URL}/rules/{ruleId}/execution/events`;
exports.GET_RULE_EXECUTION_EVENTS_URL = GET_RULE_EXECUTION_EVENTS_URL;
const getRuleExecutionEventsUrl = ruleId => `${_constants.INTERNAL_DETECTION_ENGINE_URL}/rules/${ruleId}/execution/events`;

/**
 * Get aggregated rule execution results. Each result object is built on top of all individual
 * events logged during the corresponding rule execution.
 */
exports.getRuleExecutionEventsUrl = getRuleExecutionEventsUrl;
const GET_RULE_EXECUTION_RESULTS_URL = `${_constants.INTERNAL_DETECTION_ENGINE_URL}/rules/{ruleId}/execution/results`;
exports.GET_RULE_EXECUTION_RESULTS_URL = GET_RULE_EXECUTION_RESULTS_URL;
const getRuleExecutionResultsUrl = ruleId => `${_constants.INTERNAL_DETECTION_ENGINE_URL}/rules/${ruleId}/execution/results`;
exports.getRuleExecutionResultsUrl = getRuleExecutionResultsUrl;