"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingVersion = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A symbol that represents a missing value and used when a base version of a
 * rule is not available. We need a mechanism that helps us distinguish two
 * situations:
 * - the base version is found, and its value is `undefined` or `null`
 * - the base version is not found
 *
 */
const MissingVersion = Symbol('MissingVersion');
exports.MissingVersion = MissingVersion;