"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiffableThresholdFields = exports.DiffableThreatMatchFields = exports.DiffableSavedQueryFields = exports.DiffableRule = exports.DiffableNewTermsFields = exports.DiffableMachineLearningFields = exports.DiffableEqlFields = exports.DiffableCustomQueryFields = exports.DiffableCommonFields = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsAlertingTypes = require("@kbn/securitysolution-io-ts-alerting-types");
var _rule_schema = require("../../../../rule_schema");
var _common = require("../../../../schemas/common");
var _diffable_field_types = require("./diffable_field_types");
var _build_schema = require("./build_schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DiffableCommonFields = (0, _build_schema.buildSchema)({
  required: {
    // Technical fields
    // NOTE: We might consider removing them from the schema and returning from the API
    // not via the fields diff, but via dedicated properties in the response body.
    rule_id: _rule_schema.RuleSignatureId,
    version: _rule_schema.RuleVersion,
    meta: _rule_schema.RuleMetadata,
    // Main domain fields
    name: _rule_schema.RuleName,
    tags: _rule_schema.RuleTagArray,
    description: _rule_schema.RuleDescription,
    severity: _securitysolutionIoTsAlertingTypes.Severity,
    severity_mapping: _securitysolutionIoTsAlertingTypes.SeverityMapping,
    risk_score: _securitysolutionIoTsAlertingTypes.RiskScore,
    risk_score_mapping: _securitysolutionIoTsAlertingTypes.RiskScoreMapping,
    // About -> Advanced settings
    references: _rule_schema.RuleReferenceArray,
    false_positives: _rule_schema.RuleFalsePositiveArray,
    threat: _rule_schema.ThreatArray,
    note: _rule_schema.InvestigationGuide,
    setup: _rule_schema.SetupGuide,
    related_integrations: _rule_schema.RelatedIntegrationArray,
    required_fields: _rule_schema.RequiredFieldArray,
    author: _rule_schema.RuleAuthorArray,
    license: _rule_schema.RuleLicense,
    // Other domain fields
    rule_schedule: _diffable_field_types.RuleSchedule,
    // NOTE: new field
    actions: _securitysolutionIoTsAlertingTypes.RuleActionArray,
    throttle: _securitysolutionIoTsAlertingTypes.RuleActionThrottle,
    exceptions_list: _rule_schema.ExceptionListArray,
    max_signals: _rule_schema.MaxSignals
  },
  optional: {
    rule_name_override: _diffable_field_types.RuleNameOverrideObject,
    // NOTE: new field
    timestamp_override: _diffable_field_types.TimestampOverrideObject,
    // NOTE: new field
    timeline_template: _diffable_field_types.TimelineTemplateReference,
    // NOTE: new field
    building_block: _diffable_field_types.BuildingBlockObject // NOTE: new field
  }
});
exports.DiffableCommonFields = DiffableCommonFields;
const DiffableCustomQueryFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('query'),
    data_query: _diffable_field_types.RuleKqlQuery // NOTE: new field
  },

  optional: {
    data_source: _diffable_field_types.RuleDataSource,
    // NOTE: new field
    alert_suppression: _rule_schema.AlertSuppression
  }
});
exports.DiffableCustomQueryFields = DiffableCustomQueryFields;
const DiffableSavedQueryFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('saved_query'),
    data_query: _diffable_field_types.RuleKqlQuery // NOTE: new field
  },

  optional: {
    data_source: _diffable_field_types.RuleDataSource,
    // NOTE: new field
    alert_suppression: _rule_schema.AlertSuppression
  }
});
exports.DiffableSavedQueryFields = DiffableSavedQueryFields;
const DiffableEqlFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('eql'),
    data_query: _diffable_field_types.RuleEqlQuery // NOTE: new field
  },

  optional: {
    data_source: _diffable_field_types.RuleDataSource,
    // NOTE: new field
    event_category_override: _rule_schema.EventCategoryOverride,
    timestamp_field: _rule_schema.TimestampField,
    tiebreaker_field: _rule_schema.TiebreakerField
  }
});
exports.DiffableEqlFields = DiffableEqlFields;
const DiffableThreatMatchFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('threat_match'),
    data_query: _diffable_field_types.RuleKqlQuery,
    // NOTE: new field
    threat_query: _diffable_field_types.InlineKqlQuery,
    // NOTE: new field
    threat_index: _securitysolutionIoTsAlertingTypes.threat_index,
    threat_mapping: _securitysolutionIoTsAlertingTypes.threat_mapping
  },
  optional: {
    data_source: _diffable_field_types.RuleDataSource,
    // NOTE: new field
    threat_indicator_path: _securitysolutionIoTsAlertingTypes.threat_indicator_path,
    concurrent_searches: _securitysolutionIoTsAlertingTypes.concurrent_searches,
    // Should combine concurrent_searches and items_per_search?
    items_per_search: _securitysolutionIoTsAlertingTypes.items_per_search
  }
});
exports.DiffableThreatMatchFields = DiffableThreatMatchFields;
const DiffableThresholdFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('threshold'),
    data_query: _diffable_field_types.RuleKqlQuery,
    // NOTE: new field
    threshold: _rule_schema.Threshold
  },
  optional: {
    data_source: _diffable_field_types.RuleDataSource // NOTE: new field
  }
});
exports.DiffableThresholdFields = DiffableThresholdFields;
const DiffableMachineLearningFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('machine_learning'),
    machine_learning_job_id: _securitysolutionIoTsAlertingTypes.machine_learning_job_id,
    anomaly_threshold: _common.anomaly_threshold
  },
  optional: {}
});
exports.DiffableMachineLearningFields = DiffableMachineLearningFields;
const DiffableNewTermsFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('new_terms'),
    data_query: _diffable_field_types.InlineKqlQuery,
    // NOTE: new field
    new_terms_fields: _rule_schema.NewTermsFields,
    history_window_start: _rule_schema.HistoryWindowStart
  },
  optional: {
    data_source: _diffable_field_types.RuleDataSource // NOTE: new field
  }
});

/**
 * Represents a normalized rule object that is suitable for passing to the diff algorithm.
 * Every top-level field of a diffable rule can be compared separately on its own.
 *
 * It's important to do such normalization because:
 *
 * 1. We need to compare installed rules with prebuilt rule content. These objects have similar but not exactly
 * the same interfaces. In order to compare them we need to convert them to a common interface.
 *
 * 2. It only makes sense to compare certain rule fields in combination with other fields. For example,
 * we combine `index` and `data_view_id` fields into a `RuleDataSource` object, so that later we could
 * calculate a diff for this whole object. If we don't combine them the app would successfully merge the
 * following values independently from each other without a conflict:
 *
 *   Base version: index=[logs-*], data_view_id=undefined
 *   Current version: index=[], data_view_id=some-data-view // user switched to a data view
 *   Target version: index=[logs-*, filebeat-*], data_view_id=undefined // Elastic added a new index pattern
 *   Merged version: index=[filebeat-*], data_view_id=some-data-view ???
 *
 * Instead, semantically such change represents a conflict because the data source of the rule was changed
 * in a potentially incompatible way, and the user might want to review the change and resolve it manually.
 * The user must either pick index patterns or a data view, but not both at the same time.
 *
 * NOTE: Every top-level field in a DiffableRule MUST BE LOGICALLY INDEPENDENT from other
 * top-level fields.
 */
exports.DiffableNewTermsFields = DiffableNewTermsFields;
const DiffableRule = t.intersection([DiffableCommonFields, t.union([DiffableCustomQueryFields, DiffableSavedQueryFields, DiffableEqlFields, DiffableThreatMatchFields, DiffableThresholdFields, DiffableMachineLearningFields, DiffableNewTermsFields])]);
exports.DiffableRule = DiffableRule;