"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserSettingService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A service that wraps the {@link UserProfileServiceStart} so that only the 'getCurrent' method is made available
 */
class UserSettingService {
  constructor(logger) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = logger;
  }
  start(userProfileServiceStart) {
    return {
      getCurrentUserProfileSettings: async request => {
        var _currentUserProfile$d;
        const params = {
          request,
          dataPath: 'userSettings'
        };
        const currentUserProfile = await userProfileServiceStart.getCurrent(params);
        let result = {};
        if (currentUserProfile !== null && currentUserProfile !== void 0 && (_currentUserProfile$d = currentUserProfile.data) !== null && _currentUserProfile$d !== void 0 && _currentUserProfile$d.userSettings) {
          var _currentUserProfile$d2;
          result = currentUserProfile === null || currentUserProfile === void 0 ? void 0 : (_currentUserProfile$d2 = currentUserProfile.data) === null || _currentUserProfile$d2 === void 0 ? void 0 : _currentUserProfile$d2.userSettings;
        } else {
          this.logger.debug('User Settings not found.');
        }
        return result;
      }
    };
  }
}
exports.UserSettingService = UserSettingService;