"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserAPIClient = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usersUrl = '/internal/security/users';
class UserAPIClient {
  constructor(http) {
    this.http = http;
  }
  async getUsers() {
    return await this.http.get(usersUrl);
  }
  async getUser(username) {
    return await this.http.get(`${usersUrl}/${encodeURIComponent(username)}`);
  }
  async deleteUser(username) {
    await this.http.delete(`${usersUrl}/${encodeURIComponent(username)}`);
  }
  async saveUser(user) {
    await this.http.post(`${usersUrl}/${encodeURIComponent(user.username)}`, {
      body: JSON.stringify(user)
    });
  }
  async changePassword(username, password, currentPassword) {
    const data = {
      newPassword: password
    };
    if (currentPassword) {
      data.password = currentPassword;
    }
    await this.http.post(`${usersUrl}/${encodeURIComponent(username)}/password`, {
      body: JSON.stringify(data)
    });
  }
  async disableUser(username) {
    await this.http.post(`${usersUrl}/${encodeURIComponent(username)}/_disable`);
  }
  async enableUser(username) {
    await this.http.post(`${usersUrl}/${encodeURIComponent(username)}/_enable`);
  }
}
exports.UserAPIClient = UserAPIClient;