"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteUsers = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _std = require("@kbn/std");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConfirmDeleteUsers extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "deleteUsers", () => {
      const {
        usersToDelete,
        callback,
        userAPIClient,
        notifications
      } = this.props;
      const errors = [];
      (0, _std.asyncForEach)(usersToDelete, async username => {
        try {
          await userAPIClient.deleteUser(username);
          notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.users.confirmDelete.userSuccessfullyDeletedNotificationMessage', {
            defaultMessage: 'Deleted user {username}',
            values: {
              username
            }
          }));
        } catch (e) {
          errors.push(username);
          notifications.toasts.addDanger(_i18n.i18n.translate('xpack.security.management.users.confirmDelete.userDeletingErrorNotificationMessage', {
            defaultMessage: 'Error deleting user {username}',
            values: {
              username
            }
          }));
        }
      }).then(() => {
        if (callback) {
          callback(usersToDelete, errors);
        }
      });
    });
  }
  render() {
    const {
      usersToDelete,
      onCancel
    } = this.props;
    const moreThanOne = usersToDelete.length > 1;
    const title = moreThanOne ? _i18n.i18n.translate('xpack.security.management.users.confirmDelete.deleteMultipleUsersTitle', {
      defaultMessage: 'Delete {userLength} users',
      values: {
        userLength: usersToDelete.length
      }
    }) : _i18n.i18n.translate('xpack.security.management.users.confirmDelete.deleteOneUserTitle', {
      defaultMessage: 'Delete user {userLength}',
      values: {
        userLength: usersToDelete[0]
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: title,
      onCancel: onCancel,
      onConfirm: this.deleteUsers,
      cancelButtonText: _i18n.i18n.translate('xpack.security.management.users.confirmDelete.cancelButtonLabel', {
        defaultMessage: 'Cancel'
      }),
      confirmButtonText: _i18n.i18n.translate('xpack.security.management.users.confirmDelete.confirmButtonLabel', {
        defaultMessage: 'Delete'
      }),
      buttonColor: "danger"
    }, /*#__PURE__*/_react.default.createElement("div", null, moreThanOne ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.users.confirmDelete.removingUsersDescription",
      defaultMessage: "You are about to delete these users:"
    })), /*#__PURE__*/_react.default.createElement("ul", null, usersToDelete.map(username => /*#__PURE__*/_react.default.createElement("li", {
      key: username
    }, username)))) : null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.users.confirmDelete.removingUsersWarningMessage",
      defaultMessage: "This operation cannot be undone."
    }))));
  }
}
exports.ConfirmDeleteUsers = ConfirmDeleteUsers;