"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegesAPIClient = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PrivilegesAPIClient {
  constructor(http) {
    this.http = http;
  }

  /*
   * respectLicenseLevel is an internal optional parameter soley for getting all sub-feature
   * privilieges to use in the UI. It is not meant for any other use.
   */
  async getAll({
    includeActions,
    respectLicenseLevel = true
  }) {
    return await this.http.get('/api/security/privileges', {
      query: {
        includeActions,
        respectLicenseLevel
      }
    });
  }
  async getBuiltIn() {
    return await this.http.get('/internal/security/esPrivileges/builtin');
  }
}
exports.PrivilegesAPIClient = PrivilegesAPIClient;