"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuredSubFeature = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/features-plugin/common");
var _sub_feature_privilege = require("./sub_feature_privilege");
var _sub_feature_privilege_group = require("./sub_feature_privilege_group");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SecuredSubFeature extends _common.SubFeature {
  constructor(config, actionMapping = {}) {
    super(config);
    (0, _defineProperty2.default)(this, "privileges", void 0);
    (0, _defineProperty2.default)(this, "privilegesTooltip", void 0);
    this.actionMapping = actionMapping;
    this.privilegesTooltip = config.privilegesTooltip || '';
    this.privileges = [];
    for (const privilege of this.privilegeIterator()) {
      this.privileges.push(privilege);
    }
  }
  getPrivilegeGroups() {
    return this.privilegeGroups.map(pg => new _sub_feature_privilege_group.SubFeaturePrivilegeGroup(pg, this.actionMapping));
  }
  *privilegeIterator({
    predicate = () => true
  } = {}) {
    for (const group of this.privilegeGroups) {
      yield* group.privileges.map(gp => new _sub_feature_privilege.SubFeaturePrivilege(gp, this.actionMapping[gp.id])).filter(privilege => predicate(privilege, this));
    }
  }
  getDescription() {
    return this.description;
  }
}
exports.SecuredSubFeature = SecuredSubFeature;