"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReservedRoleBadge = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _model = require("../../../../common/model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReservedRoleBadge = props => {
  const {
    role
  } = props;
  if ((0, _model.isRoleReserved)(role)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      "data-test-subj": "reservedRoleBadgeTooltip",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.reversedRoleBadge.reservedRolesCanNotBeModifiedTooltip",
        defaultMessage: "Reserved roles are built-in and cannot be removed or modified."
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      style: {
        verticalAlign: 'super'
      },
      type: 'lock'
    }));
  }
  return null;
};
exports.ReservedRoleBadge = ReservedRoleBadge;