"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegeSpaceForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../common/constants");
var _model = require("../../../../../../../common/model");
var _constants2 = require("../constants");
var _feature_table = require("../feature_table");
var _privilege_form_calculator = require("../privilege_form_calculator");
var _space_selector = require("./space_selector");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PrivilegeSpaceForm extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getForm", () => {
      const {
        spaces
      } = this.props;
      const hasSelectedSpaces = this.state.selectedSpaceIds.length > 0;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true,
        label: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.spaceSelectorFormLabel', {
          defaultMessage: 'Spaces'
        }),
        helpText: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.spaceSelectorFormHelpText', {
          defaultMessage: 'Select one or more Kibana spaces to which you wish to assign privileges.'
        })
      }, /*#__PURE__*/_react.default.createElement(_space_selector.SpaceSelector, {
        selectedSpaceIds: this.state.selectedSpaceIds,
        onChange: this.onSelectedSpacesChange,
        spaces: spaces
      })), this.getPrivilegeCallout(), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true,
        label: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.privilegeSelectorFormLabel', {
          defaultMessage: 'Privileges for all features'
        }),
        helpText: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.privilegeSelectorFormHelpText', {
          defaultMessage: 'Assign the privilege level you wish to grant to all present and future features across this space.'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
        name: `basePrivilegeButtonGroup`,
        "data-test-subj": `basePrivilegeButtonGroup`,
        isFullWidth: true,
        color: 'primary',
        options: [{
          id: 'basePrivilege_all',
          label: 'All',
          ['data-test-subj']: 'basePrivilege_all'
        }, {
          id: 'basePrivilege_read',
          label: 'Read',
          ['data-test-subj']: 'basePrivilege_read'
        }, {
          id: 'basePrivilege_custom',
          label: 'Customize',
          ['data-test-subj']: 'basePrivilege_custom'
        }],
        idSelected: this.getDisplayedBasePrivilege(),
        isDisabled: !hasSelectedSpaces,
        onChange: this.onSpaceBasePrivilegeChange,
        legend: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.basePrivilegeControlLegend', {
          defaultMessage: 'Privileges for all features'
        })
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xxs"
      }, /*#__PURE__*/_react.default.createElement("h3", null, this.getFeatureListLabel(this.state.selectedBasePrivilege.length > 0))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("p", null, this.getFeatureListDescription(this.state.selectedBasePrivilege.length > 0))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), /*#__PURE__*/_react.default.createElement(_feature_table.FeatureTable, {
        role: this.state.role,
        privilegeCalculator: this.state.privilegeCalculator,
        onChange: this.onFeaturePrivilegesChange,
        onChangeAll: this.onChangeAllFeaturePrivileges,
        kibanaPrivileges: this.props.kibanaPrivileges,
        privilegeIndex: this.state.privilegeIndex,
        canCustomizeSubFeaturePrivileges: this.props.canCustomizeSubFeaturePrivileges,
        disabled: this.state.selectedBasePrivilege.length > 0 || !hasSelectedSpaces,
        allSpacesSelected: this.state.selectedSpaceIds.includes(_constants.ALL_SPACES_ID)
      }), this.requiresGlobalPrivilegeWarning() && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "warning",
        iconType: "warning",
        "data-test-subj": "globalPrivilegeWarning",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.spacePrivilegeForm.globalPrivilegeWarning",
          defaultMessage: "Creating a global privilege might impact your other space privileges."
        })
      })));
    });
    (0, _defineProperty2.default)(this, "getSaveButton", () => {
      const {
        mode
      } = this.state;
      const isGlobal = this.isDefiningGlobalPrivilege();
      let buttonText;
      switch (mode) {
        case 'create':
          if (isGlobal) {
            buttonText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.security.management.editRolespacePrivilegeForm.createGlobalPrivilegeButton",
              defaultMessage: "Create global privilege"
            });
          } else {
            buttonText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.security.management.editRolespacePrivilegeForm.createPrivilegeButton",
              defaultMessage: "Add Kibana privilege"
            });
          }
          break;
        case 'update':
          if (isGlobal) {
            buttonText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.security.management.editRolespacePrivilegeForm.updateGlobalPrivilegeButton",
              defaultMessage: "Update global privilege"
            });
          } else {
            buttonText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.security.management.editRolespacePrivilegeForm.updatePrivilegeButton",
              defaultMessage: "Update space privilege"
            });
          }
          break;
        default:
          throw new Error(`Unsupported mode: ${mode}`);
      }
      let buttonColor = 'primary';
      if (this.requiresGlobalPrivilegeWarning()) {
        buttonColor = 'warning';
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.onSaveClick,
        fill: true,
        disabled: !this.canSave(),
        color: buttonColor,
        "data-test-subj": 'createSpacePrivilegeButton'
      }, buttonText);
    });
    (0, _defineProperty2.default)(this, "getFeatureListLabel", disabled => {
      if (disabled) {
        return _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.summaryOfFeaturePrivileges', {
          defaultMessage: 'Summary of feature privileges'
        });
      } else {
        return _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.customizeFeaturePrivileges', {
          defaultMessage: 'Customize by feature'
        });
      }
    });
    (0, _defineProperty2.default)(this, "getFeatureListDescription", disabled => {
      if (disabled) {
        return _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.featurePrivilegeSummaryDescription', {
          defaultMessage: 'Some features might be hidden by the space or affected by a global space privilege.'
        });
      } else {
        return _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.customizeFeaturePrivilegeDescription', {
          defaultMessage: 'Increase privilege levels on a per feature basis. Some features might be hidden by the space or affected by a global space privilege.'
        });
      }
    });
    (0, _defineProperty2.default)(this, "getPrivilegeCallout", () => {
      if (this.isDefiningGlobalPrivilege()) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          color: "primary",
          iconType: "iInCircle",
          title: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.globalPrivilegeNotice', {
            defaultMessage: 'These privileges will apply to all current and future spaces.'
          })
        }));
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "closeFlyout", () => {
      this.props.onCancel();
    });
    (0, _defineProperty2.default)(this, "onSaveClick", () => {
      const role = (0, _model.copyRole)(this.state.role);
      const form = role.kibana[this.state.privilegeIndex];

      // remove any spaces that no longer exist
      if (!this.isDefiningGlobalPrivilege()) {
        form.spaces = form.spaces.filter(spaceId => this.props.spaces.find(space => space.id === spaceId));
      }
      this.props.onChange(role);
    });
    (0, _defineProperty2.default)(this, "onSelectedSpacesChange", selectedSpaceIds => {
      const role = (0, _model.copyRole)(this.state.role);
      const form = role.kibana[this.state.privilegeIndex];
      form.spaces = [...selectedSpaceIds];
      form.feature = this.resetRoleFeature(form.feature, selectedSpaceIds); // Remove any feature privilege(s) that cannot currently be selected

      this.setState({
        selectedSpaceIds,
        role,
        privilegeCalculator: new _privilege_form_calculator.PrivilegeFormCalculator(this.props.kibanaPrivileges, role)
      });
    });
    (0, _defineProperty2.default)(this, "onSpaceBasePrivilegeChange", basePrivilege => {
      const role = (0, _model.copyRole)(this.state.role);
      const form = role.kibana[this.state.privilegeIndex];
      const privilegeName = basePrivilege.split('basePrivilege_')[1];
      let isCustomizingFeaturePrivileges = false;
      if (privilegeName === _constants2.CUSTOM_PRIVILEGE_VALUE) {
        form.base = [];
        isCustomizingFeaturePrivileges = true;
      } else {
        form.base = [privilegeName];
        form.feature = {};
      }
      this.setState({
        selectedBasePrivilege: privilegeName === _constants2.CUSTOM_PRIVILEGE_VALUE ? [] : [privilegeName],
        role,
        isCustomizingFeaturePrivileges,
        privilegeCalculator: new _privilege_form_calculator.PrivilegeFormCalculator(this.props.kibanaPrivileges, role)
      });
    });
    (0, _defineProperty2.default)(this, "resetRoleFeature", (roleFeature, selectedSpaceIds) => {
      const securedFeatures = this.props.kibanaPrivileges.getSecuredFeatures();
      return Object.entries(roleFeature).reduce((features, [featureId, privileges]) => {
        var _securedFeature$getPr;
        if (!Array.isArray(privileges)) {
          return features;
        }
        const securedFeature = securedFeatures.find(sf => sf.id === featureId);
        const primaryFeaturePrivilege = (_securedFeature$getPr = securedFeature === null || securedFeature === void 0 ? void 0 : securedFeature.getPrimaryFeaturePrivileges({
          includeMinimalFeaturePrivileges: true
        }).find(pfp => privileges.includes(pfp.id))) !== null && _securedFeature$getPr !== void 0 ? _securedFeature$getPr : {
          disabled: false,
          requireAllSpaces: false
        };
        const areAllSpacesSelected = selectedSpaceIds.includes(_constants.ALL_SPACES_ID);
        if (securedFeature) {
          securedFeature.getSubFeatures().forEach(subFeature => {
            subFeature.privileges.forEach(currentPrivilege => {
              if (privileges.includes(currentPrivilege.id)) {
                if (subFeature.requireAllSpaces && !areAllSpacesSelected) {
                  (0, _lodash.remove)(privileges, privilege => privilege === currentPrivilege.id);
                }
              }
            });
          });
        }
        const newFeaturePrivileges = primaryFeaturePrivilege !== null && primaryFeaturePrivilege !== void 0 && primaryFeaturePrivilege.disabled || primaryFeaturePrivilege !== null && primaryFeaturePrivilege !== void 0 && primaryFeaturePrivilege.requireAllSpaces && !areAllSpacesSelected ? [] // The primary feature privilege cannot be selected; remove that and any selected sub-feature privileges, too
        : privileges;
        return {
          ...features,
          ...(newFeaturePrivileges.length && {
            [featureId]: newFeaturePrivileges
          })
        };
      }, {});
    });
    (0, _defineProperty2.default)(this, "getDisplayedBasePrivilege", () => {
      const basePrivilege = this.state.privilegeCalculator.getBasePrivilege(this.state.privilegeIndex);
      if (basePrivilege) {
        return `basePrivilege_${basePrivilege.id}`;
      }
      return `basePrivilege_${_constants2.CUSTOM_PRIVILEGE_VALUE}`;
    });
    (0, _defineProperty2.default)(this, "onFeaturePrivilegesChange", (featureId, privileges) => {
      this.setRole(privileges, featureId);
    });
    (0, _defineProperty2.default)(this, "onChangeAllFeaturePrivileges", privileges => {
      this.setRole(privileges);
    });
    (0, _defineProperty2.default)(this, "canSave", () => {
      if (this.state.selectedSpaceIds.length === 0) {
        return false;
      }
      const form = this.state.role.kibana[this.state.privilegeIndex];
      if (form.base.length === 0 && Object.keys(form.feature).length === 0) {
        return false;
      }
      return true;
    });
    (0, _defineProperty2.default)(this, "isDefiningGlobalPrivilege", () => this.state.selectedSpaceIds.includes('*'));
    (0, _defineProperty2.default)(this, "requiresGlobalPrivilegeWarning", () => {
      const hasOtherSpacePrivilegesDefined = this.props.role.kibana.length > 0;
      return this.state.mode === 'create' && this.isDefiningGlobalPrivilege() && hasOtherSpacePrivilegesDefined;
    });
    const _role = (0, _model.copyRole)(props.role);
    let privilegeIndex = props.privilegeIndex;
    if (privilegeIndex < 0) {
      // create new form
      privilegeIndex = _role.kibana.push({
        spaces: [],
        base: [],
        feature: {}
      }) - 1;
    }
    this.state = {
      role: _role,
      privilegeIndex,
      selectedSpaceIds: [..._role.kibana[privilegeIndex].spaces],
      selectedBasePrivilege: [...(_role.kibana[privilegeIndex].base || [])],
      mode: props.privilegeIndex < 0 ? 'create' : 'update',
      isCustomizingFeaturePrivileges: false,
      privilegeCalculator: new _privilege_form_calculator.PrivilegeFormCalculator(props.kibanaPrivileges, _role)
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      onClose: this.closeFlyout,
      size: "m",
      maxWidth: true,
      maskProps: {
        headerZindexLocation: 'below'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.spacePrivilegeForm.modalTitle",
      defaultMessage: "Kibana privileges"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, this.getForm())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, this.state.privilegeCalculator.hasSupersededInheritedPrivileges(this.state.privilegeIndex) && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "warning",
      "data-test-subj": "spaceFormGlobalPermissionsSupersedeWarning",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.spacePrivilegeForm.supersededWarningTitle",
        defaultMessage: "Superseded by global privileges"
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.spacePrivilegeForm.supersededWarning",
      defaultMessage: "Declared privileges are less permissive than configured global privileges. View the privilege summary to see effective privileges."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      onClick: this.closeFlyout,
      flush: "left",
      "data-test-subj": 'cancelSpacePrivilegeButton'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.spacePrivilegeForm.cancelButton",
      defaultMessage: "Cancel"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, this.getSaveButton()))));
  }
  setRole(privileges, featureId) {
    const role = (0, _model.copyRole)(this.state.role);
    const entry = role.kibana[this.state.privilegeIndex];
    if (privileges.length === 0) {
      if (featureId) {
        delete entry.feature[featureId];
      } else {
        entry.feature = {};
      }
    } else {
      let securedFeaturesToSet = this.props.kibanaPrivileges.getSecuredFeatures();
      if (featureId) {
        securedFeaturesToSet = [securedFeaturesToSet.find(sf => sf.id === featureId)];
      }
      securedFeaturesToSet.forEach(feature => {
        const nextFeaturePrivilege = feature.getPrimaryFeaturePrivileges({
          includeMinimalFeaturePrivileges: true
        }).find(pfp => {
          if (pfp !== null && pfp !== void 0 && pfp.disabled || pfp !== null && pfp !== void 0 && pfp.requireAllSpaces && !this.state.selectedSpaceIds.includes(_constants.ALL_SPACES_ID)) {
            return false;
          }
          return Array.isArray(privileges) && privileges.includes(pfp.id);
        });
        let newPrivileges = [];
        if (nextFeaturePrivilege) {
          newPrivileges = [nextFeaturePrivilege.id];
          feature.getSubFeaturePrivileges().forEach(psf => {
            if (Array.isArray(privileges) && privileges.includes(psf.id)) {
              if (!psf.requireAllSpaces || psf.requireAllSpaces && this.state.selectedSpaceIds.includes(_constants.ALL_SPACES_ID)) {
                newPrivileges.push(psf.id);
              }
            }
          });
        }
        if (newPrivileges.length === 0) {
          delete entry.feature[feature.id];
        } else {
          entry.feature[feature.id] = newPrivileges;
        }
      });
    }
    this.setState({
      role,
      privilegeCalculator: new _privilege_form_calculator.PrivilegeFormCalculator(this.props.kibanaPrivileges, role)
    });
  }
}
exports.PrivilegeSpaceForm = PrivilegeSpaceForm;
(0, _defineProperty2.default)(PrivilegeSpaceForm, "defaultProps", {
  privilegeIndex: -1
});