"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubFeatureForm = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SubFeatureForm = props => {
  const groupsWithPrivileges = props.subFeature.getPrivilegeGroups().filter(group => group.privileges.length > 0);
  const getTooltip = () => {
    if (!props.subFeature.privilegesTooltip) {
      return null;
    }
    const tooltipContent = /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, props.subFeature.privilegesTooltip));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      iconProps: {
        className: 'eui-alignTop'
      },
      type: "iInCircle",
      color: "subdued",
      content: tooltipContent
    });
  };
  if (groupsWithPrivileges.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, props.subFeature.name, " ", getTooltip())), props.subFeature.description && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: 'subdued',
    size: 'xs',
    "data-test-subj": "subFeatureDescription",
    "aria-describedby": `${props.subFeature.name} description text`
  }, props.subFeature.description)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, groupsWithPrivileges.map(renderPrivilegeGroup)));
  function renderPrivilegeGroup(privilegeGroup, index) {
    switch (privilegeGroup.groupType) {
      case 'independent':
        return renderIndependentPrivilegeGroup(privilegeGroup, index);
      case 'mutually_exclusive':
        return renderMutuallyExclusivePrivilegeGroup(privilegeGroup, index);
      default:
        throw new Error(`Unsupported privilege group type: ${privilegeGroup.groupType}`);
    }
  }
  function renderIndependentPrivilegeGroup(privilegeGroup, index) {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: index
    }, privilegeGroup.privileges.map(privilege => {
      const isGranted = props.privilegeCalculator.isIndependentSubFeaturePrivilegeGranted(props.featureId, privilege.id, props.privilegeIndex);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        key: privilege.id,
        id: `${props.featureId}_${privilege.id}`,
        label: privilege.name,
        "data-test-subj": "independentSubFeaturePrivilegeControl",
        onChange: e => {
          const {
            checked
          } = e.target;
          if (checked) {
            props.onChange([...props.selectedFeaturePrivileges, privilege.id]);
          } else {
            props.onChange(props.selectedFeaturePrivileges.filter(sp => sp !== privilege.id));
          }
        },
        checked: isGranted,
        disabled: props.disabled,
        compressed: true
      });
    }));
  }
  function renderMutuallyExclusivePrivilegeGroup(privilegeGroup, index) {
    var _firstSelectedPrivile;
    const firstSelectedPrivilege = props.privilegeCalculator.getSelectedMutuallyExclusiveSubFeaturePrivilege(props.featureId, privilegeGroup, props.privilegeIndex);
    const options = [...privilegeGroup.privileges.map((privilege, privilegeIndex) => {
      return {
        id: privilege.id,
        label: privilege.name,
        isDisabled: props.disabled
      };
    })];
    options.push({
      id: _constants.NO_PRIVILEGE_VALUE,
      label: 'None',
      isDisabled: props.disabled
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      key: index,
      buttonSize: "compressed",
      "data-test-subj": "mutexSubFeaturePrivilegeControl",
      isFullWidth: true,
      options: options,
      idSelected: (_firstSelectedPrivile = firstSelectedPrivilege === null || firstSelectedPrivilege === void 0 ? void 0 : firstSelectedPrivilege.id) !== null && _firstSelectedPrivile !== void 0 ? _firstSelectedPrivile : _constants.NO_PRIVILEGE_VALUE,
      isDisabled: props.disabled,
      onChange: selectedPrivilegeId => {
        // Deselect all privileges which belong to this mutually-exclusive group
        const privilegesWithoutGroupEntries = props.selectedFeaturePrivileges.filter(sp => !privilegeGroup.privileges.some(privilege => privilege.id === sp));
        // fire on-change with the newly selected privilege
        if (selectedPrivilegeId === _constants.NO_PRIVILEGE_VALUE) {
          props.onChange(privilegesWithoutGroupEntries);
        } else {
          props.onChange([...privilegesWithoutGroupEntries, selectedPrivilegeId]);
        }
      },
      legend: _i18n.i18n.translate('xpack.security.management.editRole.subFeatureForm.controlLegendText', {
        defaultMessage: '{subFeatureName} sub-feature privilege',
        values: {
          subFeatureName: props.subFeature.name
        }
      })
    });
  }
};
exports.SubFeatureForm = SubFeatureForm;