"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeAllPrivilegesControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./change_all_privileges.scss");
var _eui = require("@elastic/eui");
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ChangeAllPrivilegesControl extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "onSelectPrivilege", privilege => {
      this.props.onChange(privilege);
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState({
        isPopoverOpen: !this.state.isPopoverOpen
      });
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
  }
  render() {
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: this.onButtonClick,
      className: 'secPrivilegeFeatureChangeAllLink',
      "data-test-subj": "changeAllPrivilegesButton"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.changeAllPrivilegesLink",
      defaultMessage: "Bulk actions"
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "arrowDown"
    })));
    const items = this.props.privileges.map(privilege => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: privilege.id,
        "data-test-subj": `changeAllPrivileges-${privilege.id}`,
        onClick: () => {
          this.onSelectPrivilege(privilege.id);
        },
        disabled: this.props.disabled
      }, _lodash.default.upperFirst(privilege.id));
    });
    items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: _constants.NO_PRIVILEGE_VALUE,
      "data-test-subj": `changeAllPrivileges-${_constants.NO_PRIVILEGE_VALUE}`,
      onClick: () => {
        this.onSelectPrivilege(_constants.NO_PRIVILEGE_VALUE);
      },
      disabled: this.props.disabled
    }, _lodash.default.upperFirst(_constants.NO_PRIVILEGE_VALUE)));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: 'changeAllFeaturePrivilegesPopover',
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      anchorPosition: "downLeft"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: items
    }));
  }
}
exports.ChangeAllPrivilegesControl = ChangeAllPrivilegesControl;