"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isGlobalPrivilegeDefinition = isGlobalPrivilegeDefinition;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Determines if the passed privilege spec defines global privileges.
 * @param privilegeSpec
 */
function isGlobalPrivilegeDefinition(privilegeSpec) {
  if (!privilegeSpec.spaces || privilegeSpec.spaces.length === 0) {
    return true;
  }
  return privilegeSpec.spaces.includes('*');
}