"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.roleMappingsManagementApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _breadcrumb = require("../../components/breadcrumb");
var _readonly_badge = require("../badges/readonly_badge");
var _url_utils = require("../url_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const roleMappingsManagementApp = Object.freeze({
  id: 'role_mappings',
  create({
    getStartServices
  }) {
    const title = _i18n.i18n.translate('xpack.security.management.roleMappingsTitle', {
      defaultMessage: 'Role Mappings'
    });
    return {
      id: this.id,
      order: 40,
      title,
      async mount({
        element,
        theme$,
        setBreadcrumbs,
        history
      }) {
        const [[core], {
          RoleMappingsGridPage
        }, {
          EditRoleMappingPage
        }, {
          RoleMappingsAPIClient
        }, {
          RolesAPIClient
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./role_mappings_grid'))), Promise.resolve().then(() => _interopRequireWildcard(require('./edit_role_mapping'))), Promise.resolve().then(() => _interopRequireWildcard(require('./role_mappings_api_client'))), Promise.resolve().then(() => _interopRequireWildcard(require('../roles')))]);
        core.chrome.docTitle.change(title);
        const roleMappingsAPIClient = new RoleMappingsAPIClient(core.http);
        const EditRoleMappingsPageWithBreadcrumbs = ({
          action
        }) => {
          const {
            name
          } = (0, _reactRouterDom.useParams)();

          // Additional decoding is a workaround for a bug in react-router's version of the `history` module.
          // See https://github.com/elastic/kibana/issues/82440
          const decodedName = name ? (0, _url_utils.tryDecodeURIComponent)(name) : undefined;
          const breadcrumbObj = action === 'edit' && name && decodedName ? {
            text: decodedName,
            href: `/edit/${encodeURIComponent(name)}`
          } : {
            text: _i18n.i18n.translate('xpack.security.roleMappings.createBreadcrumb', {
              defaultMessage: 'Create'
            })
          };
          return /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
            text: breadcrumbObj.text,
            href: breadcrumbObj.href
          }, /*#__PURE__*/_react.default.createElement(EditRoleMappingPage, {
            action: action,
            name: decodedName,
            roleMappingsAPI: roleMappingsAPIClient,
            rolesAPIClient: new RolesAPIClient(core.http),
            notifications: core.notifications,
            docLinks: core.docLinks,
            history: history,
            readOnly: !core.application.capabilities.role_mappings.save
          }));
        };
        (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
          services: core
        }, /*#__PURE__*/_react.default.createElement(core.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
          theme$: theme$
        }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
          history: history
        }, /*#__PURE__*/_react.default.createElement(_readonly_badge.ReadonlyBadge, {
          "data-test-subj": "readOnlyBadge",
          featureId: "role_mappings",
          tooltip: _i18n.i18n.translate('xpack.security.management.roleMappings.readonlyTooltip', {
            defaultMessage: 'Unable to create or edit role mappings'
          })
        }), /*#__PURE__*/_react.default.createElement(_breadcrumb.BreadcrumbsProvider, {
          onChange: (0, _breadcrumb.createBreadcrumbsChangeHandler)(core.chrome, setBreadcrumbs)
        }, /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
          text: title,
          href: "/"
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: ['/', ''],
          exact: true
        }, /*#__PURE__*/_react.default.createElement(RoleMappingsGridPage, {
          notifications: core.notifications,
          rolesAPIClient: new RolesAPIClient(core.http),
          roleMappingsAPI: roleMappingsAPIClient,
          docLinks: core.docLinks,
          history: history,
          navigateToApp: core.application.navigateToApp,
          readOnly: !core.application.capabilities.role_mappings.save
        })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/edit/:name?"
        }, /*#__PURE__*/_react.default.createElement(EditRoleMappingsPageWithBreadcrumbs, {
          action: "edit"
        })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/clone/:name"
        }, /*#__PURE__*/_react.default.createElement(EditRoleMappingsPageWithBreadcrumbs, {
          action: "clone"
        })))))))), element);
        return () => {
          (0, _reactDom.unmountComponentAtNode)(element);
        };
      }
    };
  }
});
exports.roleMappingsManagementApp = roleMappingsManagementApp;