"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleSelector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _model = require("../../../../../common/model");
var _role_combo_box = require("../../../role_combo_box");
var _add_role_template_button = require("./add_role_template_button");
var _role_template_editor = require("./role_template_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RoleSelector extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getRoleComboBox", () => {
      const {
        roles = []
      } = this.props.roleMapping;
      return /*#__PURE__*/_react.default.createElement(_role_combo_box.RoleComboBox, {
        "data-test-subj": "roleMappingFormRolesCombo",
        placeholder: _i18n.i18n.translate('xpack.security.management.editRoleMapping.selectRolesPlaceholder', {
          defaultMessage: 'Select one or more roles'
        }),
        isLoading: this.state.roles.length === 0,
        availableRoles: this.state.roles,
        selectedRoleNames: roles,
        onChange: selectedRoles => {
          this.props.onChange({
            ...this.props.roleMapping,
            roles: selectedRoles,
            role_templates: []
          });
        },
        isDisabled: this.props.readOnly
      });
    });
    (0, _defineProperty2.default)(this, "getRoleTemplates", () => {
      const {
        role_templates: roleTemplates = []
      } = this.props.roleMapping;
      return /*#__PURE__*/_react.default.createElement("div", null, roleTemplates.map((rt, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: index
      }, /*#__PURE__*/_react.default.createElement(_role_template_editor.RoleTemplateEditor, {
        "data-test-subj": "roleMappingFormRoleTemplateEditor",
        canUseStoredScripts: this.props.canUseStoredScripts,
        canUseInlineScripts: this.props.canUseInlineScripts,
        roleTemplate: rt,
        onChange: updatedTemplate => {
          const templates = [...(this.props.roleMapping.role_templates || [])];
          templates.splice(index, 1, updatedTemplate);
          this.props.onChange({
            ...this.props.roleMapping,
            role_templates: templates
          });
        },
        onDelete: () => {
          const templates = [...(this.props.roleMapping.role_templates || [])];
          templates.splice(index, 1);
          this.props.onChange({
            ...this.props.roleMapping,
            role_templates: templates
          });
        },
        readOnly: this.props.readOnly
      }), index === roleTemplates.length - 1 && this.props.readOnly ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null))), this.conditionallyRenderAddRoleTemplateButton());
    });
    (0, _defineProperty2.default)(this, "conditionallyRenderAddRoleTemplateButton", () => {
      if (!this.props.readOnly) {
        return /*#__PURE__*/_react.default.createElement(_add_role_template_button.AddRoleTemplateButton, {
          canUseStoredScripts: this.props.canUseStoredScripts,
          canUseInlineScripts: this.props.canUseInlineScripts,
          onClick: type => {
            switch (type) {
              case 'inline':
                {
                  const templates = this.props.roleMapping.role_templates || [];
                  this.props.onChange({
                    ...this.props.roleMapping,
                    roles: [],
                    role_templates: [...templates, {
                      template: {
                        source: ''
                      }
                    }]
                  });
                  break;
                }
              case 'stored':
                {
                  const templates = this.props.roleMapping.role_templates || [];
                  this.props.onChange({
                    ...this.props.roleMapping,
                    roles: [],
                    role_templates: [...templates, {
                      template: {
                        id: ''
                      }
                    }]
                  });
                  break;
                }
              default:
                throw new Error(`Unsupported template type: ${type}`);
            }
          }
        });
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "getHelpText", () => {
      if (this.props.mode === 'roles' && this.hasDeprecatedRolesAssigned()) {
        return /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "deprecatedRolesAssigned"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.deprecatedRolesAssigned",
          defaultMessage: "This mapping is assigned a deprecated role. Please migrate to a supported role."
        }));
      }
    });
    (0, _defineProperty2.default)(this, "hasDeprecatedRolesAssigned", () => {
      var _this$props$roleMappi, _this$props$roleMappi2;
      return (_this$props$roleMappi = (_this$props$roleMappi2 = this.props.roleMapping.roles) === null || _this$props$roleMappi2 === void 0 ? void 0 : _this$props$roleMappi2.some(r => this.state.roles.some(role => role.name === r && (0, _model.isRoleDeprecated)(role)))) !== null && _this$props$roleMappi !== void 0 ? _this$props$roleMappi : false;
    });
    this.state = {
      roles: []
    };
  }
  async componentDidMount() {
    const roles = await this.props.rolesAPIClient.getRoles();
    this.setState({
      roles
    });
  }
  render() {
    const {
      mode
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      helpText: this.getHelpText()
    }, mode === 'roles' ? this.getRoleComboBox() : this.getRoleTemplates());
  }
}
exports.RoleSelector = RoleSelector;
(0, _defineProperty2.default)(RoleSelector, "defaultProps", {
  readOnly: false
});