"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddRoleTemplateButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddRoleTemplateButton = props => {
  if (!props.canUseStoredScripts && !props.canUseInlineScripts) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "warning",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.roleTemplatesUnavailableTitle",
        defaultMessage: "Role templates unavailable"
      })
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRoleMapping.roleTemplatesUnavailable",
      defaultMessage: "Role templates cannot be used when scripts are disabled in Elasticsearch."
    })));
  }
  const addRoleTemplate = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRoleMapping.addRoleTemplate",
    defaultMessage: "Add template"
  });
  if (props.canUseInlineScripts) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "plusInCircle",
      onClick: () => props.onClick('inline'),
      "data-test-subj": "addRoleTemplateButton"
    }, addRoleTemplate);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    onClick: () => props.onClick('stored'),
    "data-test-subj": "addRoleTemplateButton"
  }, addRoleTemplate);
};
exports.AddRoleTemplateButton = AddRoleTemplateButton;