"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APIKeysGridPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react2 = _interopRequireWildcard(require("react"));
var _public = require("@kbn/es-ui-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _breadcrumb = require("../../../components/breadcrumb");
var _token_field = require("../../../components/token_field");
var _api_key_flyout = require("./api_key_flyout");
var _api_keys_empty_prompt = require("./api_keys_empty_prompt");
var _invalidate_provider = require("./invalidate_provider");
var _not_enabled = require("./not_enabled");
var _permission_denied = require("./permission_denied");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATE_FORMAT = 'MMMM Do YYYY HH:mm:ss';
class APIKeysGridPage extends _react2.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "renderTable", () => {
      var _apiKeys$reduce, _apiKeys$reduce2, _this$props$readOnly;
      const {
        apiKeys,
        selectedItems,
        isLoadingTable,
        isAdmin,
        error
      } = this.state;
      const message = isLoadingTable ? /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeys.table.apiKeysTableLoadingMessage",
        defaultMessage: "Loading API keys\u2026"
      }) : undefined;
      const sorting = {
        sort: {
          field: 'creation',
          direction: 'desc'
        }
      };
      const pagination = {
        initialPageSize: 20,
        pageSizeOptions: [10, 20, 50]
      };
      const selection = {
        onSelectionChange: newSelectedItems => {
          this.setState({
            selectedItems: newSelectedItems
          });
        }
      };
      const search = {
        toolsLeft: selectedItems.length ? /*#__PURE__*/_react2.default.createElement(_invalidate_provider.InvalidateProvider, {
          isAdmin: isAdmin,
          notifications: this.props.notifications,
          apiKeysAPIClient: this.props.apiKeysAPIClient
        }, invalidateApiKeyPrompt => {
          return /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
            onClick: () => invalidateApiKeyPrompt(selectedItems.map(({
              name,
              id
            }) => ({
              name,
              id
            })), this.onApiKeysInvalidated),
            color: "danger",
            "data-test-subj": "bulkInvalidateActionButton"
          }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.apiKeys.table.invalidateApiKeyButton",
            defaultMessage: "Delete {count, plural, one {API key} other {API keys}}",
            values: {
              count: selectedItems.length
            }
          }));
        }) : undefined,
        box: {
          incremental: true
        },
        filters: isAdmin ? [{
          type: 'field_value_selection',
          field: 'username',
          name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.userFilterLabel', {
            defaultMessage: 'User'
          }),
          multiSelect: false,
          options: Object.keys((_apiKeys$reduce = apiKeys === null || apiKeys === void 0 ? void 0 : apiKeys.reduce((apiKeysMap, apiKey) => {
            apiKeysMap[apiKey.username] = true;
            return apiKeysMap;
          }, {})) !== null && _apiKeys$reduce !== void 0 ? _apiKeys$reduce : {}).map(username => {
            return {
              value: username,
              view: /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
                delay: "long",
                position: "left",
                content: username
              }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
                alignItems: "center",
                gutterSize: "s",
                responsive: false
              }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
                grow: false
              }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
                type: "user"
              })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
                css: (0, _react.css)`
                            overflow: hidden;
                          `,
                grow: false
              }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
                className: "eui-textTruncate"
              }, username))))
            };
          })
        }, {
          type: 'field_value_selection',
          field: 'realm',
          name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.realmFilterLabel', {
            defaultMessage: 'Realm'
          }),
          multiSelect: false,
          options: Object.keys((_apiKeys$reduce2 = apiKeys === null || apiKeys === void 0 ? void 0 : apiKeys.reduce((apiKeysMap, apiKey) => {
            apiKeysMap[apiKey.realm] = true;
            return apiKeysMap;
          }, {})) !== null && _apiKeys$reduce2 !== void 0 ? _apiKeys$reduce2 : {}).map(realm => {
            return {
              value: realm,
              view: realm
            };
          })
        }] : undefined
      };
      const callOutTitle = this.determineCallOutTitle((_this$props$readOnly = this.props.readOnly) !== null && _this$props$readOnly !== void 0 ? _this$props$readOnly : false);
      return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, !isAdmin ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
        title: callOutTitle,
        color: "primary",
        iconType: "user"
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, null)) : undefined, /*#__PURE__*/_react2.default.createElement(_invalidate_provider.InvalidateProvider, {
        isAdmin: isAdmin,
        notifications: this.props.notifications,
        apiKeysAPIClient: this.props.apiKeysAPIClient
      }, invalidateApiKeyPrompt => /*#__PURE__*/_react2.default.createElement(_eui.EuiInMemoryTable, {
        items: apiKeys !== null && apiKeys !== void 0 ? apiKeys : [],
        itemId: "id",
        columns: this.getColumnConfig(invalidateApiKeyPrompt),
        search: search,
        sorting: sorting,
        selection: this.props.readOnly ? undefined : selection,
        pagination: pagination,
        loading: isLoadingTable,
        error: error && _i18n.i18n.translate('xpack.security.management.apiKeysEmptyPrompt.errorMessage', {
          defaultMessage: 'Could not load API keys.'
        }),
        message: message,
        isSelectable: true
      })));
    });
    (0, _defineProperty2.default)(this, "getColumnConfig", invalidateApiKeyPrompt => {
      const {
        isAdmin,
        createdApiKey
      } = this.state;
      let config = [];
      config = config.concat([{
        field: 'name',
        name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.nameColumnName', {
          defaultMessage: 'Name'
        }),
        sortable: true,
        render: (name, recordAP) => {
          return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
            color: "subdued",
            size: "s"
          }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
            "data-test-subj": `apiKeyRowName-${recordAP.name}`,
            onClick: () => {
              this.setState({
                selectedApiKey: recordAP,
                isUpdateFlyoutVisible: true
              });
            }
          }, name));
        }
      }]);
      if (isAdmin) {
        config = config.concat([{
          field: 'username',
          name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.userNameColumnName', {
            defaultMessage: 'User'
          }),
          sortable: true,
          render: username => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
            alignItems: "center",
            gutterSize: "s",
            responsive: false
          }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
            type: "user"
          })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, null, username)))
        }, {
          field: 'realm',
          name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.realmColumnName', {
            defaultMessage: 'Realm'
          }),
          sortable: true
        }]);
      }
      config = config.concat([{
        field: 'creation',
        name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.creationDateColumnName', {
          defaultMessage: 'Created'
        }),
        sortable: true,
        mobileOptions: {
          show: false
        },
        render: (creation, item) => /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
          content: (0, _momentTimezone.default)(creation).format(DATE_FORMAT)
        }, item.id === (createdApiKey === null || createdApiKey === void 0 ? void 0 : createdApiKey.id) ? /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
          color: "success"
        }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.apiKeys.table.createdBadge",
          defaultMessage: "Just now"
        })) : /*#__PURE__*/_react2.default.createElement("span", null, (0, _momentTimezone.default)(creation).fromNow()))
      }, {
        name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.statusColumnName', {
          defaultMessage: 'Status'
        }),
        render: ({
          expiration
        }) => {
          if (!expiration) {
            return /*#__PURE__*/_react2.default.createElement(_eui.EuiHealth, {
              color: "primary"
            }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.security.management.apiKeys.table.statusActive",
              defaultMessage: "Active"
            }));
          }
          if (Date.now() > expiration) {
            return /*#__PURE__*/_react2.default.createElement(_eui.EuiHealth, {
              color: "subdued"
            }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.security.management.apiKeys.table.statusExpired",
              defaultMessage: "Expired"
            }));
          }
          return /*#__PURE__*/_react2.default.createElement(_eui.EuiHealth, {
            color: "warning"
          }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
            content: (0, _momentTimezone.default)(expiration).format(DATE_FORMAT)
          }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.apiKeys.table.statusExpires",
            defaultMessage: "Expires {timeFromNow}",
            values: {
              timeFromNow: (0, _momentTimezone.default)(expiration).fromNow()
            }
          })));
        }
      }]);
      if (!this.props.readOnly) {
        config.push({
          actions: [{
            name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.deleteAction', {
              defaultMessage: 'Delete'
            }),
            description: _i18n.i18n.translate('xpack.security.management.apiKeys.table.deleteDescription', {
              defaultMessage: 'Delete this API key'
            }),
            icon: 'trash',
            type: 'icon',
            color: 'danger',
            onClick: item => invalidateApiKeyPrompt([{
              id: item.id,
              name: item.name
            }], this.onApiKeysInvalidated),
            'data-test-subj': 'apiKeysTableDeleteAction'
          }]
        });
      }
      return config;
    });
    (0, _defineProperty2.default)(this, "onApiKeysInvalidated", apiKeysInvalidated => {
      if (apiKeysInvalidated.length) {
        this.reloadApiKeys();
      }
    });
    (0, _defineProperty2.default)(this, "reloadApiKeys", () => {
      this.setState({
        isLoadingApp: false,
        isLoadingTable: true,
        createdApiKey: undefined,
        error: undefined
      });
      this.loadApiKeys();
    });
    (0, _defineProperty2.default)(this, "loadApiKeys", async () => {
      try {
        const {
          isAdmin
        } = this.state;
        const {
          apiKeys
        } = await this.props.apiKeysAPIClient.getApiKeys(isAdmin);
        this.setState({
          apiKeys
        });
      } catch (e) {
        this.setState({
          error: e
        });
      }
      this.setState({
        isLoadingApp: false,
        isLoadingTable: false
      });
    });
    this.state = {
      isLoadingApp: true,
      isLoadingTable: false,
      isAdmin: false,
      canManage: false,
      areApiKeysEnabled: false,
      apiKeys: undefined,
      selectedItems: [],
      error: undefined,
      selectedApiKey: undefined,
      isUpdateFlyoutVisible: false
    };
  }
  componentDidMount() {
    this.checkPrivileges();
  }
  render() {
    return (
      /*#__PURE__*/
      // Flyout to create new ApiKey
      _react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_sharedUxRouter.Route, {
        path: "/create"
      }, /*#__PURE__*/_react2.default.createElement(_breadcrumb.Breadcrumb, {
        text: _i18n.i18n.translate('xpack.security.management.apiKeys.createBreadcrumb', {
          defaultMessage: 'Create'
        }),
        href: "/create"
      }, /*#__PURE__*/_react2.default.createElement(_api_key_flyout.ApiKeyFlyout, {
        onSuccess: createApiKeyResponse => {
          this.props.history.push({
            pathname: '/'
          });
          this.reloadApiKeys();
          this.setState({
            createdApiKey: createApiKeyResponse
          });
        },
        onCancel: () => {
          this.props.history.push({
            pathname: '/'
          });
          this.setState({
            selectedApiKey: undefined
          });
        }
      }))),
      // Flyout to update or view ApiKey
      this.state.isUpdateFlyoutVisible && /*#__PURE__*/_react2.default.createElement(_api_key_flyout.ApiKeyFlyout, {
        onSuccess: (createApiKeyResponse, updateApiKeyResponse) => {
          this.reloadApiKeys();
          this.displayUpdatedApiKeyToast(updateApiKeyResponse);
          this.setState({
            selectedApiKey: undefined,
            isUpdateFlyoutVisible: false
          });
        },
        onCancel: () => {
          this.setState({
            selectedApiKey: undefined,
            isUpdateFlyoutVisible: false
          });
        },
        apiKey: this.state.selectedApiKey,
        readonly: this.props.readOnly
      }), this.renderContent())
    );
  }
  renderContent() {
    var _this$state$createdAp, _this$state$createdAp2, _this$props$readOnly2;
    const {
      isLoadingApp,
      isLoadingTable,
      areApiKeysEnabled,
      isAdmin,
      canManage,
      error,
      apiKeys
    } = this.state;
    if (!apiKeys) {
      if (isLoadingApp) {
        return /*#__PURE__*/_react2.default.createElement(_public.SectionLoading, null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.apiKeys.table.loadingApiKeysDescription",
          defaultMessage: "Loading API keys\u2026"
        }));
      }
      if (!canManage) {
        return /*#__PURE__*/_react2.default.createElement(_permission_denied.PermissionDenied, null);
      }
      if (error) {
        return /*#__PURE__*/_react2.default.createElement(_api_keys_empty_prompt.ApiKeysEmptyPrompt, {
          error: error
        }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
          iconType: "refresh",
          onClick: this.reloadApiKeys
        }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.accountManagement.apiKeys.retryButton",
          defaultMessage: "Try again"
        })));
      }
      if (!areApiKeysEnabled) {
        return /*#__PURE__*/_react2.default.createElement(_not_enabled.NotEnabled, null);
      }
    }
    if (!isLoadingTable && apiKeys && apiKeys.length === 0) {
      if (this.props.readOnly) {
        return /*#__PURE__*/_react2.default.createElement(_api_keys_empty_prompt.ApiKeysEmptyPrompt, {
          readOnly: this.props.readOnly
        });
      } else {
        return /*#__PURE__*/_react2.default.createElement(_api_keys_empty_prompt.ApiKeysEmptyPrompt, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public2.reactRouterNavigate)(this.props.history, '/create'), {
          fill: true,
          iconType: "plusInCircleFilled",
          "data-test-subj": "apiKeysCreatePromptButton",
          href: '/'
        }), /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.apiKeys.table.createButton",
          defaultMessage: "Create API key"
        })));
      }
    }
    const concatenated = `${(_this$state$createdAp = this.state.createdApiKey) === null || _this$state$createdAp === void 0 ? void 0 : _this$state$createdAp.id}:${(_this$state$createdAp2 = this.state.createdApiKey) === null || _this$state$createdAp2 === void 0 ? void 0 : _this$state$createdAp2.api_key}`;
    const description = this.determineDescription(isAdmin, (_this$props$readOnly2 = this.props.readOnly) !== null && _this$props$readOnly2 !== void 0 ? _this$props$readOnly2 : false);
    return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
      paddingSize: "none",
      bottomBorder: true,
      pageTitle: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeys.table.apiKeysTitle",
        defaultMessage: "API Keys"
      }),
      description: description,
      rightSideItems: this.props.readOnly ? undefined : [/*#__PURE__*/_react2.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public2.reactRouterNavigate)(this.props.history, '/create'), {
        fill: true,
        iconType: "plusInCircleFilled",
        "data-test-subj": "apiKeysCreateTableButton"
      }), /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeys.table.createButton",
        defaultMessage: "Create API key"
      }))]
    }), this.state.createdApiKey && !this.state.isLoadingTable && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
      color: "success",
      iconType: "check",
      title: _i18n.i18n.translate('xpack.security.management.apiKeys.createSuccessMessage', {
        defaultMessage: "Created API key '{name}'",
        values: {
          name: this.state.createdApiKey.name
        }
      })
    }, /*#__PURE__*/_react2.default.createElement("p", null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.successDescription",
      defaultMessage: "Copy this key now. You will not be able to view it again."
    })), /*#__PURE__*/_react2.default.createElement(_token_field.SelectableTokenField, {
      options: [{
        key: 'base64',
        value: btoa(concatenated),
        icon: 'empty',
        label: _i18n.i18n.translate('xpack.security.management.apiKeys.base64Label', {
          defaultMessage: 'Base64'
        }),
        description: _i18n.i18n.translate('xpack.security.management.apiKeys.base64Description', {
          defaultMessage: 'Format used to authenticate with Elasticsearch.'
        })
      }, {
        key: 'json',
        value: JSON.stringify(this.state.createdApiKey),
        icon: 'empty',
        label: _i18n.i18n.translate('xpack.security.management.apiKeys.jsonLabel', {
          defaultMessage: 'JSON'
        }),
        description: _i18n.i18n.translate('xpack.security.management.apiKeys.jsonDescription', {
          defaultMessage: 'Full API response.'
        })
      }, {
        key: 'beats',
        value: concatenated,
        icon: 'logoBeats',
        label: _i18n.i18n.translate('xpack.security.management.apiKeys.beatsLabel', {
          defaultMessage: 'Beats'
        }),
        description: _i18n.i18n.translate('xpack.security.management.apiKeys.beatsDescription', {
          defaultMessage: 'Format used to configure Beats.'
        })
      }, {
        key: 'logstash',
        value: concatenated,
        icon: 'logoLogstash',
        label: _i18n.i18n.translate('xpack.security.management.apiKeys.logstashLabel', {
          defaultMessage: 'Logstash'
        }),
        description: _i18n.i18n.translate('xpack.security.management.apiKeys.logstashDescription', {
          defaultMessage: 'Format used to configure Logstash.'
        })
      }]
    }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
      paddingSize: "none"
    }, this.renderTable()));
  }
  async checkPrivileges() {
    try {
      const {
        isAdmin,
        canManage,
        areApiKeysEnabled
      } = await this.props.apiKeysAPIClient.checkPrivileges();
      this.setState({
        isAdmin,
        canManage,
        areApiKeysEnabled
      });
      if (!canManage && !this.props.readOnly || !areApiKeysEnabled) {
        this.setState({
          isLoadingApp: false
        });
      } else {
        this.loadApiKeys();
      }
    } catch (e) {
      var _e$body$message, _e$body;
      this.props.notifications.toasts.addDanger(_i18n.i18n.translate('xpack.security.management.apiKeys.table.fetchingApiKeysErrorMessage', {
        defaultMessage: 'Error checking privileges: {message}',
        values: {
          message: (_e$body$message = (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message) !== null && _e$body$message !== void 0 ? _e$body$message : ''
        }
      }));
    }
  }
  determineDescription(isAdmin, readOnly) {
    if (isAdmin) {
      return /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeys.table.apiKeysAllDescription",
        defaultMessage: "View and delete API keys, which send requests on behalf of a user."
      });
    } else if (readOnly) {
      return /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeys.table.apiKeysReadOnlyDescription",
        defaultMessage: "View your API keys, which send requests on your behalf."
      });
    } else {
      return /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeys.table.apiKeysOwnDescription",
        defaultMessage: "View and delete your API keys, which send requests on your behalf."
      });
    }
  }
  determineCallOutTitle(readOnly) {
    if (readOnly) {
      return /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeys.table.readOnlyOwnKeysWarning",
        defaultMessage: "You only have permission to view your own API keys."
      });
    } else {
      return /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeys.table.manageOwnKeysWarning",
        defaultMessage: "You only have permission to manage your own API keys."
      });
    }
  }
  displayUpdatedApiKeyToast(updateApiKeyResponse) {
    if (updateApiKeyResponse) {
      var _this$state$selectedA;
      this.props.notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.security.management.apiKeys.updateSuccessMessage', {
          defaultMessage: "Updated API key '{name}'",
          values: {
            name: (_this$state$selectedA = this.state.selectedApiKey) === null || _this$state$selectedA === void 0 ? void 0 : _this$state$selectedA.name
          }
        }),
        'data-test-subj': 'updateApiKeySuccessToast'
      });
    }
  }
}
exports.APIKeysGridPage = APIKeysGridPage;
(0, _defineProperty2.default)(APIKeysGridPage, "defaultProps", {
  readOnly: false
});