"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccessAgreementPage = AccessAgreementPage;
exports.renderAccessAgreementPage = renderAccessAgreementPage;
require("./access_agreement_page.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactMarkdown = _interopRequireDefault(require("react-markdown"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _parse_next = require("../../../common/parse_next");
var _components = require("../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AccessAgreementPage({
  http,
  fatalErrors,
  notifications
}) {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [accessAgreement, setAccessAgreement] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    http.get('/internal/security/access_agreement/state').then(response => setAccessAgreement(response.accessAgreement)).catch(err => fatalErrors.add(err));
  }, [http, fatalErrors]);
  const onAcknowledge = (0, _react.useCallback)(async e => {
    e.preventDefault();
    try {
      setIsLoading(true);
      await http.post('/internal/security/access_agreement/acknowledge');
      window.location.href = (0, _parse_next.parseNext)(window.location.href, http.basePath.serverBasePath);
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.security.accessAgreement.acknowledgeErrorMessage', {
          defaultMessage: 'Could not acknowledge access agreement.'
        })
      });
      setIsLoading(false);
    }
  }, [http, notifications]);
  const content = accessAgreement ? /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: onAcknowledge
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "secAccessAgreementPage__textWrapper"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "secAccessAgreementPage__text"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "left"
  }, /*#__PURE__*/_react.default.createElement(_reactMarkdown.default, null, accessAgreement)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "secAccessAgreementPage__footer"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "secAccessAgreementPage__footerInner"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    color: "primary",
    onClick: onAcknowledge,
    isDisabled: isLoading,
    isLoading: isLoading,
    "data-test-subj": "accessAgreementAcknowledge"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accessAgreement.acknowledgeButtonText",
    defaultMessage: "Acknowledge and continue"
  }))))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
    lines: 10
  }));
  return /*#__PURE__*/_react.default.createElement(_components.AuthenticationStatePage, {
    className: "secAccessAgreementPage",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accessAgreement.title",
      defaultMessage: "Access Agreement"
    })
  }, content, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }));
}
function renderAccessAgreementPage(i18nStart, {
  element,
  theme$
}, props) {
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(i18nStart.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(AccessAgreementPage, props))), element);
  return () => _reactDom.default.unmountComponentAtNode(element);
}