"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _shared_imports = require("../shared_imports");
var _app = require("./app");
var _app_context = require("./contexts/app_context");
var _profiler_context = require("./contexts/profiler_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderApp = ({
  el,
  http,
  I18nContext,
  notifications,
  initialLicenseStatus,
  theme$,
  location
}) => {
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    args: {
      initialLicenseStatus,
      notifications,
      http,
      location
    }
  }, /*#__PURE__*/_react.default.createElement(_profiler_context.ProfileContextProvider, null, /*#__PURE__*/_react.default.createElement(_app.App, null))))), el);
  return () => (0, _reactDom.unmountComponentAtNode)(el);
};
exports.renderApp = renderApp;