"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfileQueryEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lzString = require("lz-string");
var _hooks = require("../../hooks");
var _app_context = require("../../contexts/app_context");
var _profiler_context = require("../../contexts/profiler_context");
var _editor = require("./editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_INDEX_VALUE = '_all';
const INITIAL_EDITOR_VALUE = `{
  "query":{
    "match_all" : {}
  }
}`;

/**
 * This component should only need to render once.
 *
 * Drives state changes for mine via profiler action context.
 */
const ProfileQueryEditor = /*#__PURE__*/(0, _react.memo)(() => {
  const editorRef = (0, _react.useRef)(null);
  const indexInputRef = (0, _react.useRef)(null);
  const dispatch = (0, _profiler_context.useProfilerActionContext)();
  const {
    getLicenseStatus,
    notifications,
    location
  } = (0, _app_context.useAppContext)();
  const queryParams = new URLSearchParams(location.search);
  const indexName = queryParams.get('index');
  const searchProfilerQueryURI = queryParams.get('load_from');
  const searchProfilerQuery = searchProfilerQueryURI && (0, _lzString.decompressFromEncodedURIComponent)(searchProfilerQueryURI.replace(/^data:text\/plain,/, ''));
  const requestProfile = (0, _hooks.useRequestProfile)();
  const handleProfileClick = async () => {
    dispatch({
      type: 'setProfiling',
      value: true
    });
    try {
      const {
        current: editor
      } = editorRef;
      const {
        data: result,
        error
      } = await requestProfile({
        query: editorRef.current.getValue(),
        index: indexInputRef.current.value
      });
      if (error) {
        notifications.addDanger(error);
        editor.focus();
        return;
      }
      if (result === null) {
        return;
      }
      dispatch({
        type: 'setCurrentResponse',
        value: result
      });
    } finally {
      dispatch({
        type: 'setProfiling',
        value: false
      });
    }
  };
  const onEditorReady = (0, _react.useCallback)(editorInstance => editorRef.current = editorInstance, []);
  const licenseEnabled = getLicenseStatus().valid;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    className: "prfDevTool__sense",
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.searchProfiler.formIndexLabel', {
      defaultMessage: 'Index'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "indexName",
    disabled: !licenseEnabled,
    inputRef: ref => {
      if (ref) {
        indexInputRef.current = ref;
        ref.value = indexName ? indexName : DEFAULT_INDEX_VALUE;
      }
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 10
  }, /*#__PURE__*/_react.default.createElement(_editor.Editor, {
    onEditorReady: onEditorReady,
    licenseEnabled: licenseEnabled,
    initialValue: searchProfilerQuery ? searchProfilerQuery : INITIAL_EDITOR_VALUE
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "prfDevTool__profileButtonContainer",
    gutterSize: "none",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "profileButton",
    fill: true,
    disabled: !licenseEnabled,
    onClick: () => handleProfileClick()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.searchProfiler.formProfileButtonLabel', {
    defaultMessage: 'Profile'
  })))))));
});
exports.ProfileQueryEditor = ProfileQueryEditor;