"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightDetailsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lib = require("../../lib");
var _percentage_badge = require("../percentage_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HighlightDetailsTable = ({
  breakdown
}) => {
  const columns = [{
    name: 'Description',
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      content: item.tip
    }, /*#__PURE__*/_react.default.createElement("span", null, item.key))
  }, {
    name: 'Time',
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      style: {
        backgroundColor: item.color
      }
    }, /*#__PURE__*/_react.default.createElement("span", null, (0, _lib.nsToPretty)(item.time, 1)))
  }, {
    name: 'Percentage',
    render: item => /*#__PURE__*/_react.default.createElement(_percentage_badge.PercentageBadge, {
      timePercentage: String(item.relative),
      label: item.relative + '%'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: breakdown,
    columns: columns
  });
};
exports.HighlightDetailsTable = HighlightDetailsTable;